/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.FileNotFoundException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import mobac.exceptions.StopAllDownloadsException;
import mobac.program.AtlasThread;
import mobac.program.PauseResumeHandler;
import mobac.program.interfaces.MapSourceListener;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import org.apache.log4j.Logger;

public class JobDispatcher {
    private static Logger log = Logger.getLogger(JobDispatcher.class);
    protected final AtlasThread atlasThread;
    protected final PauseResumeHandler pauseResumeHandler;
    protected final MapSourceListener mapSourceListener;
    protected final WorkerThread[] workers;
    protected int maxJobsInQueue = 100;
    protected int minJobsInQueue = 50;
    protected final BlockingQueue<Job> jobQueue = new LinkedBlockingQueue<Job>();

    public JobDispatcher(AtlasThread atlasThread, int threadCount, PauseResumeHandler pauseResumeHandler, MapSourceListener mapSourceListener) {
        this.atlasThread = atlasThread;
        this.pauseResumeHandler = pauseResumeHandler;
        this.mapSourceListener = mapSourceListener;
        this.workers = new WorkerThread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            this.workers[i] = new WorkerThread(i);
        }
    }

    protected void finalize() throws Throwable {
        this.terminateAllWorkerThreads();
        super.finalize();
    }

    public void terminateAllWorkerThreads() {
        this.cancelOutstandingJobs();
        log.trace("Killing all worker threads");
        for (int i = 0; i < this.workers.length; ++i) {
            try {
                WorkerThread w = this.workers[i];
                if (w != null) {
                    w.interrupt();
                }
                this.workers[i] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
    }

    public void addJob(Job job) throws InterruptedException {
        while (this.jobQueue.size() > this.maxJobsInQueue) {
            Thread.sleep(200L);
            if (this.jobQueue.size() >= this.minJobsInQueue || this.maxJobsInQueue >= 2000) continue;
            this.maxJobsInQueue *= 2;
            this.minJobsInQueue *= 2;
        }
        this.jobQueue.put(job);
    }

    public void addErrorJob(Job job) {
        try {
            this.jobQueue.put(job);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getWaitingJobCount() {
        return this.jobQueue.size();
    }

    public boolean isAtLeastOneWorkerActive() {
        for (int i = 0; i < this.workers.length; ++i) {
            WorkerThread w = this.workers[i];
            if (w == null || w.idle || w.getState() == Thread.State.WAITING) continue;
            return true;
        }
        log.debug("All worker threads are idle");
        return false;
    }

    public class WorkerThread
    extends DelayedInterruptThread
    implements MapSourceListener {
        Job job;
        boolean idle;
        private Logger log;

        public WorkerThread(int threadNum) {
            super(String.format("WorkerThread %02d", threadNum));
            this.job = null;
            this.idle = true;
            this.log = Logger.getLogger(WorkerThread.class);
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                this.executeJobs();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.trace("Thread is terminating");
        }

        protected void executeJobs() throws InterruptedException {
            while (!this.isInterrupted()) {
                try {
                    JobDispatcher.this.pauseResumeHandler.pauseWait();
                    this.idle = true;
                    this.job = JobDispatcher.this.jobQueue.take();
                    this.idle = false;
                }
                catch (InterruptedException e) {
                    return;
                }
                if (this.job == null) {
                    return;
                }
                try {
                    this.job.run(JobDispatcher.this);
                    this.job = null;
                }
                catch (InterruptedException e) {
                }
                catch (StopAllDownloadsException e) {
                    JobDispatcher.this.terminateAllWorkerThreads();
                    JobDispatcher.this.cancelOutstandingJobs();
                    this.log.warn("All downloads has been stoppened: " + e.getMessage());
                    return;
                }
                catch (FileNotFoundException e) {
                    this.log.error("Download failed: " + e.getMessage());
                }
                catch (Exception e) {
                    this.log.error("Unknown error occured while executing the job: ", e);
                }
                catch (OutOfMemoryError e) {
                    this.log.error("", e);
                    Thread.sleep(5000L);
                    System.gc();
                }
            }
        }

        @Override
        public void tileDownloaded(int size) {
            JobDispatcher.this.mapSourceListener.tileDownloaded(size);
        }

        @Override
        public void tileLoadedFromCache(int size) {
            JobDispatcher.this.mapSourceListener.tileLoadedFromCache(size);
        }

        public AtlasThread getAtlasThread() {
            return JobDispatcher.this.atlasThread;
        }
    }

    public static interface Job {
        public void run(JobDispatcher var1) throws Exception;
    }
}

