/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import mobac.Main;
import mobac.program.Logging;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;

public class ProgramInfo {
    public static String PROG_NAME = "Mobile Atlas Creator";
    public static String PROG_NAME_SHORT = "MOBAC";
    private static String VERSION = null;
    private static String SVN_REVISION = "unknown";
    private static String userAgent = "";
    private static boolean titleHideRevision = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        InputStream propIn = Main.class.getResourceAsStream("mobac.properties");
        try {
            Properties props = new Properties();
            props.load(propIn);
            VERSION = props.getProperty("mobac.version");
            titleHideRevision = Boolean.parseBoolean(props.getProperty("mobac.revision.hide", "false"));
            System.getProperties().putAll((Map<?, ?>)props);
        }
        catch (Exception e) {
            String msg = "Error reading mobac.properties";
            GUIExceptionHandler.processFatalExceptionSimpleDialog(msg, e);
        }
        finally {
            Utilities.closeStream(propIn);
        }
        propIn = Main.class.getResourceAsStream("mobac-rev.properties");
        try {
            String rev;
            if (propIn != null) {
                Properties props = new Properties();
                props.load(propIn);
                rev = props.getProperty("mobac.revision");
                SVN_REVISION = Integer.toString(Utilities.parseSVNRevision(rev));
            } else {
                rev = System.getProperty("mobac.revision.fallback");
                SVN_REVISION = Integer.toString(Utilities.parseSVNRevision(rev)) + " exported";
            }
        }
        catch (Exception e) {
            Logging.LOG.error("Error reading mobac-rev.properties", e);
        }
        finally {
            Utilities.closeStream(propIn);
        }
        userAgent = PROG_NAME_SHORT + "/" + ProgramInfo.getVersion().replaceAll(" ", "_");
    }

    public static String getVersion() {
        if (VERSION != null) {
            return VERSION;
        }
        return "UNKNOWN";
    }

    public static String getRevisionStr() {
        return SVN_REVISION;
    }

    public static String getVersionTitle() {
        String title = PROG_NAME;
        title = PROG_NAME_SHORT != null ? title + " (" + PROG_NAME_SHORT + ") " : title + " ";
        title = VERSION != null ? title + ProgramInfo.getVersion() : title + "unknown version";
        return title;
    }

    public static String getCompleteTitle() {
        String title = ProgramInfo.getVersionTitle();
        if (!titleHideRevision) {
            title = title + " (" + SVN_REVISION + ")";
        }
        return title;
    }

    public static String getUserAgent() {
        return userAgent;
    }
}

