/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.RequiresSQLite;
import mobac.program.model.TileImageParameters;
import mobac.utilities.jdbc.SQLiteLoader;

public abstract class AbstractSQLite
extends AtlasCreator
implements RequiresSQLite {
    private static final int MAX_BATCH_SIZE = 1000;
    protected File databaseFile;
    protected Connection conn = null;
    protected PreparedStatement prepStmt;

    public AbstractSQLite() {
        SQLiteLoader.loadSQLiteOrShowError();
    }

    protected void openConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            String url = "jdbc:sqlite:/" + this.databaseFile.getAbsolutePath();
            this.conn = DriverManager.getConnection(url);
        }
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        super.testAtlas();
        try {
            SQLiteLoader.loadSQLite();
        }
        catch (SQLException e) {
            throw new AtlasTestException(SQLiteLoader.getMsgSqliteMissing());
        }
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, AtlasTestException, InterruptedException {
        super.startAtlasCreation(atlas, customAtlasDir);
        this.databaseFile = new File(this.atlasDir, this.getDatabaseFileName());
        this.log.debug("SQLite Database file: " + this.databaseFile);
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.abortAtlasCreation();
    }

    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.finishAtlasCreation();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        int maxMapProgress = 2 * (this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1);
        this.atlasProgress.initMapCreation(maxMapProgress);
        TileImageParameters param = this.map.getParameters();
        if (param != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, param.getFormat());
        }
        try {
            this.conn.setAutoCommit(false);
            int batchTileCount = 0;
            int tilesWritten = 0;
            Runtime r = Runtime.getRuntime();
            long heapMaxSize = r.maxMemory();
            this.prepStmt = this.conn.prepareStatement(this.getTileInsertSQL());
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData == null) continue;
                        this.writeTile(x, y, this.zoom, sourceTileData);
                        ++tilesWritten;
                        long heapAvailable = heapMaxSize - r.totalMemory() + r.freeMemory();
                        if (heapAvailable >= 0x1400000L && ++batchTileCount < 1000) continue;
                        this.log.trace("Executing batch containing " + batchTileCount + " tiles");
                        this.prepStmt.executeBatch();
                        this.prepStmt.clearBatch();
                        System.gc();
                        this.conn.commit();
                        this.atlasProgress.incMapCreationProgress(batchTileCount);
                        batchTileCount = 0;
                        continue;
                    }
                    catch (IOException e) {
                        throw new MapCreationException(this.map, (Throwable)e);
                    }
                }
            }
            this.prepStmt.executeBatch();
            this.prepStmt.clearBatch();
            this.prepStmt.close();
            this.prepStmt = null;
            System.gc();
            if (tilesWritten > 0) {
                this.updateTileMetaInfo();
            }
            this.log.trace("Final commit containing " + batchTileCount + " tiles");
            this.conn.commit();
            this.atlasProgress.setMapCreationProgress(maxMapProgress);
        }
        catch (SQLException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected abstract String getTileInsertSQL();

    protected abstract void writeTile(int var1, int var2, int var3, byte[] var4) throws SQLException, IOException;

    protected abstract String getDatabaseFileName();

    protected abstract void updateTileMetaInfo() throws SQLException;
}

