/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.ProgramInfo;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.aqm.FlatPackCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageParameters;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ArrayOutputStream;

@AtlasCreatorName(value="AlpineQuestMap (AQM)")
@SupportedParameters(names={TileImageParameters.Name.format, TileImageParameters.Name.height, TileImageParameters.Name.width})
public class AlpineQuestMap
extends AtlasCreator {
    public static final String AQM_VERSION = "2";
    public static final String AQM_HEADER = "V2HEADER";
    public static final String AQM_LEVEL = "V2LEVEL";
    public static final String AQM_LEVEL_DELIMITER = "@LEVEL";
    public static final String AQM_END_DELIMITER = "#END";
    private static final String[] SCALES = new String[]{"1:512 000 000", "1:256 000 000", "1:128 000 000", "1:64 000 000", "1:32 000 000", "1:16 000 000", "1:8 000 000", "1:4 000 000", "1:2 000 000", "1:1 000 000", "1:512 000", "1:256 000", "1:128 000", "1:64 000", "1:32 000", "1:16 000", "1:8 000", "1:4 000", "1:2 000", "1:1 000", "1:512", "1:128", "1:64", "1:32", "1:16", "1:8", "1:4", "1:2", "1:1"};
    private FlatPackCreator packCreator = null;
    private File filePack = null;
    private double xResizeRatio = 1.0;
    private double yResizeRatio = 1.0;
    private int lastZoomLevel = 0;

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        if (layer.getMapCount() > 0) {
            this.filePack = new File(this.atlasDir + "/" + layer.getName() + ".AQM");
            this.packCreator = new FlatPackCreator(this.filePack);
            this.lastZoomLevel = -1;
            this.addMapHeader(layer.getMap(0).getMapSource().toString(), layer.getName());
            for (int i = 0; i < layer.getMapCount(); ++i) {
                Insets bounds = new Insets(layer.getMap((int)i).getMinTileCoordinate().y, layer.getMap((int)i).getMinTileCoordinate().x, layer.getMap((int)i).getMaxTileCoordinate().y, layer.getMap((int)i).getMaxTileCoordinate().x);
                while (i + 1 < layer.getMapCount() && layer.getMap(i).getZoom() == layer.getMap(i + 1).getZoom()) {
                    bounds.top = Math.min(bounds.top, layer.getMap((int)(++i)).getMinTileCoordinate().y);
                    bounds.left = Math.min(bounds.left, layer.getMap((int)i).getMinTileCoordinate().x);
                    bounds.bottom = Math.max(bounds.bottom, layer.getMap((int)i).getMaxTileCoordinate().y);
                    bounds.right = Math.max(bounds.right, layer.getMap((int)i).getMaxTileCoordinate().x);
                }
                this.addLevelHeader(layer.getMap(i), bounds);
            }
        }
    }

    @Override
    public void finishLayerCreation() throws IOException {
        this.packCreator.add(new byte[0], AQM_END_DELIMITER);
        this.packCreator.close();
        this.packCreator = null;
        super.finishLayerCreation();
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        if (this.packCreator != null) {
            this.packCreator.close();
        }
        this.packCreator = null;
        if (this.filePack != null) {
            Utilities.deleteFile(this.filePack);
        }
        this.filePack = null;
        super.abortAtlasCreation();
    }

    private final void addMapHeader(String strID, String strName) throws IOException {
        String strVersion = AQM_VERSION;
        String strSoftware = ProgramInfo.getCompleteTitle();
        String strDate = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        String strCreator = "";
        StringWriter w = new StringWriter();
        w.write("[map]\n");
        w.write("id = " + strID + "\n");
        w.write("name = " + strName + "\n");
        w.write("version = 2\n");
        w.write("date = " + strDate + "\n");
        w.write("creator = \n");
        w.write("software = " + strSoftware + "\n");
        w.write("\n");
        w.flush();
        w.close();
        this.packCreator.add(w.getBuffer().toString().getBytes(), AQM_HEADER);
    }

    private final void addLevelHeader(MapInterface map, Insets bounds) throws IOException {
        int tileSize = map.getMapSource().getMapSpace().getTileSize();
        int xMin = bounds.left / tileSize;
        int xMax = bounds.right / tileSize;
        int yMin = bounds.top / tileSize;
        int yMax = bounds.bottom / tileSize;
        String strID = new DecimalFormat("00").format(map.getZoom());
        String strName = map.getLayer().getName();
        if (strName == null || strName.length() == 0) {
            strName = I18nUtils.localizedStringForKey("Unnamed", new Object[0]);
        }
        String strScale = "";
        if (map.getZoom() >= 0 && map.getZoom() < SCALES.length) {
            strScale = SCALES[map.getZoom()];
        }
        String strDataSource = map.getMapSource().toString();
        String strCopyright = map.getMapSource().toString();
        String strProjection = "mercator";
        String strGeoid = "";
        if (MapSpace.ProjectionCategory.SPHERE.equals((Object)map.getMapSource().getMapSpace().getProjectionCategory())) {
            strGeoid = "sphere";
        } else if (MapSpace.ProjectionCategory.ELLIPSOID.equals((Object)map.getMapSource().getMapSpace().getProjectionCategory())) {
            strGeoid = "wgs84";
        }
        long nbTotalTiles = 256L * Math.round(Math.pow(2.0, map.getZoom())) / (long)tileSize;
        String strImageFormat = null;
        Dimension tilesSize = null;
        if (map.getParameters() != null) {
            strImageFormat = map.getParameters().getFormat().getFileExt();
            tilesSize = map.getParameters().getDimension();
        } else {
            strImageFormat = map.getMapSource().getTileImageType().getFileExt();
            tilesSize = map.getTileSize();
        }
        if (strImageFormat != null) {
            strImageFormat = strImageFormat.toUpperCase();
        }
        StringWriter w = new StringWriter();
        w.write("[level]\n");
        w.write("id = " + strID + "\n");
        w.write("name = " + strName + "\n");
        w.write("scale = " + strScale + "\n");
        w.write("datasource = " + strDataSource + "\n");
        w.write("copyright = " + strCopyright + "\n");
        w.write("projection = mercator\n");
        w.write("geoid = " + strGeoid + "\n");
        w.write("xtsize = " + (int)tilesSize.getWidth() + "\n");
        w.write("ytsize = " + (int)tilesSize.getHeight() + "\n");
        w.write("xtratio = " + (double)nbTotalTiles / 360.0 + "\n");
        w.write("ytratio = " + (double)nbTotalTiles / 360.0 + "\n");
        w.write("xtoffset = " + (double)nbTotalTiles / 2.0 + "\n");
        w.write("ytoffset = " + (double)nbTotalTiles / 2.0 + "\n");
        w.write("xtmin = " + xMin + "\n");
        w.write("xtmax = " + xMax + "\n");
        w.write("ytmin = " + (nbTotalTiles - (long)yMax) + "\n");
        w.write("ytmax = " + (nbTotalTiles - (long)yMin) + "\n");
        w.write("background = #FFFFFF\n");
        w.write("imgformat = " + strImageFormat + "\n");
        w.write("\n");
        w.flush();
        w.close();
        this.packCreator.add(w.getBuffer().toString().getBytes(), AQM_LEVEL);
    }

    @Override
    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && (MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSource.getMapSpace().getProjectionCategory()) || MapSpace.ProjectionCategory.ELLIPSOID.equals((Object)mapSource.getMapSpace().getProjectionCategory()));
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.xResizeRatio = 1.0;
        this.yResizeRatio = 1.0;
        if (this.parameters != null) {
            int mapTileSize = map.getMapSource().getMapSpace().getTileSize();
            if (this.parameters.getWidth() != mapTileSize || this.parameters.getHeight() != mapTileSize) {
                this.xResizeRatio = (double)this.parameters.getWidth() / (double)mapTileSize;
                this.yResizeRatio = (double)this.parameters.getHeight() / (double)mapTileSize;
            } else {
                this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
            }
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            if (this.map.getZoom() > this.lastZoomLevel) {
                this.addLevelDelimiter();
                this.lastZoomLevel = this.map.getZoom();
            }
            this.addLevelTiles();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    private final void addLevelDelimiter() throws IOException {
        this.packCreator.add(new byte[0], AQM_LEVEL_DELIMITER);
    }

    private final void addLevelTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        long nbTotalTiles = 256L * Math.round(Math.pow(2.0, this.map.getZoom())) / (long)this.tileSize;
        BufferedImage tileImage = null;
        Graphics2D graphics = null;
        ArrayOutputStream buffer = null;
        TileImageDataWriter writer = null;
        if (this.parameters != null || this.xResizeRatio != 1.0 || this.yResizeRatio != 1.0) {
            tileImage = new BufferedImage(this.parameters.getWidth(), this.parameters.getHeight(), 5);
            graphics = tileImage.createGraphics();
            graphics.setTransform(AffineTransform.getScaleInstance(this.xResizeRatio, this.yResizeRatio));
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            writer = this.parameters.getFormat().getDataWriter();
            buffer = new ArrayOutputStream(3 * this.parameters.getWidth() * this.parameters.getHeight());
            ImageIO.setUseCache(false);
            writer.initialize();
        }
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    if (graphics != null && buffer != null && writer != null) {
                        BufferedImage tile = ImageIO.read(new ByteArrayInputStream(sourceTileData));
                        graphics.drawImage((Image)tile, 0, 0, null);
                        buffer.reset();
                        writer.processImage(tileImage, buffer);
                        sourceTileData = buffer.toByteArray();
                        if (sourceTileData == null) {
                            throw new MapCreationException("Image resizing failed.", this.map);
                        }
                    }
                    this.packCreator.add(sourceTileData, "" + x + "_" + (nbTotalTiles - (long)y));
                    continue;
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }
}

