/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="CacheBox (PACK)")
@SupportedParameters(names={TileImageParameters.Name.format})
public class CacheBox
extends AtlasCreator {
    private File packFile = null;
    private RandomAccessFile packRaFile = null;
    private MapInfo[] mapInfos;
    private int nextMapOffsetIndex = 0;
    private MapInfo activeMapInfo;

    @Override
    protected void testAtlas() throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            if (layer.getMapCount() == 0) {
                throw new AtlasTestException("Empty layers are not allowed", layer);
            }
            Class<?> mapSourceClass = layer.getMap(0).getMapSource().getClass();
            for (MapInterface map : layer) {
                if (mapSourceClass.equals(map.getMapSource().getClass())) continue;
                throw new AtlasTestException("Different map sources are not allowed within one layer", map);
            }
        }
    }

    @Override
    public void finishAtlasCreation() throws IOException {
    }

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        this.nextMapOffsetIndex = 0;
        this.packFile = new File(this.atlasDir, layer.getName() + ".pack");
        if (this.packFile.exists()) {
            Utilities.deleteFile(this.packFile);
        }
        this.packRaFile = new RandomAccessFile(this.packFile, "rw");
        this.writeString(layer.getMap(0).getMapSource().getName(), 32);
        this.writeString(layer.getName(), 128);
        this.writeString("", 256);
        this.writeLong(0L);
        int mapCount = layer.getMapCount();
        this.writeInt(mapCount);
        long offset = 436L;
        offset += (long)(mapCount * 28);
        this.mapInfos = new MapInfo[mapCount + 1];
        int i = 0;
        for (MapInterface map : layer) {
            int minX = map.getMinTileCoordinate().x / 256;
            int minY = map.getMinTileCoordinate().y / 256;
            int maxX = map.getMaxTileCoordinate().x / 256;
            int maxY = map.getMaxTileCoordinate().y / 256;
            int tilesInMap = (maxX - minX + 1) * (maxY - minY + 1);
            this.writeInt(map.getZoom());
            this.writeInt(minX);
            this.writeInt(maxX);
            this.writeInt(minY);
            this.writeInt(maxY);
            this.writeLong(offset);
            this.mapInfos[i++] = new MapInfo(map, offset, tilesInMap, minX, minY, maxX, maxY);
            this.log.trace(String.format("Offset to index table [%d]: 0x%X", i, offset));
            offset += (long)(tilesInMap * 8);
        }
        this.mapInfos[i] = new MapInfo(null, offset, 0, 0, 0, 0, 0);
        this.log.trace(String.format("End of bounding boxes table: 0x%X", this.packRaFile.getFilePointer()));
        this.packRaFile.seek(offset);
        this.log.trace(String.format("Start of tile data: 0x%X", this.packRaFile.getFilePointer()));
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        TileImageParameters param = map.getParameters();
        if (param != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, param.getFormat());
        }
        this.activeMapInfo = this.mapInfos[this.nextMapOffsetIndex++];
        if (!this.activeMapInfo.map.equals(map)) {
            throw new RuntimeException("Map does not match offset info!");
        }
        this.xMin = this.activeMapInfo.minX;
        this.xMax = this.activeMapInfo.maxX;
        this.yMin = this.activeMapInfo.minY;
        this.yMax = this.activeMapInfo.maxY;
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        int offsetIndex = 0;
        long[] offsets = new long[this.activeMapInfo.tileCount];
        try {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                for (int x = this.xMin; x <= this.xMax; ++x) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    offsets[offsetIndex++] = this.packRaFile.getFilePointer();
                    if (sourceTileData == null) continue;
                    this.packRaFile.write(sourceTileData);
                }
            }
            long pos = this.packRaFile.getFilePointer();
            this.packRaFile.seek(this.activeMapInfo.indexTableOffset - 8L);
            for (long tileoffset : offsets) {
                this.writeLong(tileoffset);
            }
            this.packRaFile.seek(pos);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    @Override
    public void finishLayerCreation() throws IOException {
        long tableOffset = this.mapInfos[this.mapInfos.length - 1].indexTableOffset;
        long offset = this.packRaFile.getFilePointer();
        this.packRaFile.seek(tableOffset - 8L);
        this.packRaFile.writeLong(CacheBox.swapLong(offset));
        this.mapInfos = null;
        this.packFile = null;
        this.packRaFile.close();
        this.packRaFile = null;
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        this.mapInfos = null;
        Utilities.closeFile(this.packRaFile);
        this.packRaFile = null;
        if (this.packFile != null) {
            Utilities.deleteFile(this.packFile);
        }
        this.packFile = null;
    }

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    private void writeString(String text, int length) throws IOException {
        byte[] buf = new byte[length];
        byte[] asciiBytes = text.getBytes("ASCII");
        System.arraycopy(asciiBytes, 0, buf, 0, Math.min(length, asciiBytes.length));
        for (int i = asciiBytes.length; i < length; ++i) {
            buf[i] = 32;
        }
        this.packRaFile.write(buf);
    }

    private void writeInt(int v) throws IOException {
        this.packRaFile.writeInt(CacheBox.swapInt(v));
    }

    private void writeLong(long v) throws IOException {
        this.packRaFile.writeLong(CacheBox.swapLong(v));
    }

    public static final int swapInt(int v) {
        return v >>> 24 | v << 24 | v << 8 & 0xFF0000 | v >> 8 & 0xFF00;
    }

    public static final long swapLong(long v) {
        long b1 = v >> 0 & 0xFFL;
        long b2 = v >> 8 & 0xFFL;
        long b3 = v >> 16 & 0xFFL;
        long b4 = v >> 24 & 0xFFL;
        long b5 = v >> 32 & 0xFFL;
        long b6 = v >> 40 & 0xFFL;
        long b7 = v >> 48 & 0xFFL;
        long b8 = v >> 56 & 0xFFL;
        return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 << 0;
    }

    private class MapInfo {
        final MapInterface map;
        final long indexTableOffset;
        final int tileCount;
        final int minX;
        final int minY;
        final int maxX;
        final int maxY;

        public MapInfo(MapInterface map, long indexOffset, int tileCount, int minX, int minY, int maxX, int maxY) {
            this.map = map;
            this.indexTableOffset = indexOffset;
            this.tileCount = tileCount;
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

