/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.Ozi;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="CacheWolf (WFL)")
@SupportedParameters(names={TileImageParameters.Name.format, TileImageParameters.Name.height, TileImageParameters.Name.width})
public class CacheWolf
extends Ozi {
    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDirs(this.layerDir);
        }
        catch (IOException e1) {
            throw new MapCreationException(this.map, (Throwable)e1);
        }
        if (this.parameters == null) {
            super.createTiles();
            this.writeWflFile();
        } else {
            this.createTiles();
        }
    }

    @Override
    protected void createTiles() throws InterruptedException, MapCreationException {
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            CWFileTileWriter mapTileWriter = new CWFileTileWriter();
            MapTileBuilder mapTileBuilder = new MapTileBuilder(this, mapTileWriter, true);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        finally {
            ctp.cleanup();
        }
    }

    private void writeWflFile() throws MapCreationException {
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        try {
            this.writeWflFile(this.mapName, 0, 0, width, height);
        }
        catch (IOException e) {
            throw new MapCreationException("Error writing wfl file: " + e.getMessage(), this.map, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWflFile(String filename, int tilex, int tiley, int width, int height) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, filename + ".wfl"));
            OutputStreamWriter mapWriter = new OutputStreamWriter((OutputStream)fout, TEXT_FILE_CHARSET);
            MapSpace mapSpace = this.mapSource.getMapSpace();
            int xStart = this.xMin * this.tileSize;
            int yStart = this.yMin * this.tileSize;
            if (this.parameters != null) {
                xStart += tilex * this.parameters.getWidth();
                yStart += tiley * this.parameters.getHeight();
            }
            double topLeftLon = mapSpace.cXToLon(xStart, this.zoom);
            double topLeftLat = mapSpace.cYToLat(yStart, this.zoom);
            double bottomRightLon = mapSpace.cXToLon(xStart + width, this.zoom);
            double bottomRightLat = mapSpace.cYToLat(yStart + height, this.zoom);
            double[] affine = new double[]{0.0, 0.0, 0.0, 0.0};
            affine[1] = (bottomRightLon - topLeftLon) / (double)width;
            affine[2] = (bottomRightLat - topLeftLat) / (double)height;
            for (double d : affine) {
                mapWriter.write(Double.toString(d) + "\n");
            }
            mapWriter.write(Double.toString(topLeftLat) + "\n");
            mapWriter.write(Double.toString(topLeftLon) + "\n");
            mapWriter.write(Double.toString(bottomRightLat) + "\n");
            mapWriter.write(Double.toString(bottomRightLon) + "\n");
            mapWriter.flush();
            mapWriter.close();
        }
        catch (Throwable throwable) {
            Utilities.closeStream(fout);
            throw throwable;
        }
        Utilities.closeStream(fout);
    }

    public class CWFileTileWriter
    implements MapTileWriter {
        public CWFileTileWriter() throws IOException {
            CacheWolf.this.log.debug("Writing tiles to set folder: " + CacheWolf.this.layerDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format("%s_%dx%d", CacheWolf.this.mapName, tilex, tiley);
            File f = new File(CacheWolf.this.layerDir, tileFileName + '.' + imageFormat);
            FileOutputStream out = new FileOutputStream(f);
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
            CacheWolf.this.writeWflFile(tileFileName, tilex, tiley, CacheWolf.this.parameters.getWidth(), CacheWolf.this.parameters.getHeight());
        }

        @Override
        public void finalizeMap() {
        }
    }
}

