/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.TrekBuddy;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import mobac.utilities.stream.LittleEndianOutputStream;

@AtlasCreatorName(value="Glopus Map File (GMF)", type="Gmf")
public class GlopusMapFile
extends TrekBuddy {
    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.mapTileWriter = new GlopusTileWriter(layer);
    }

    @Override
    public void finishLayerCreation() throws IOException {
        this.mapTileWriter.finalizeMap();
        this.mapTileWriter = null;
        super.finishLayerCreation();
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            ((GlopusTileWriter)this.mapTileWriter).initMap();
            if (this.parameters != null) {
                this.createCustomTiles();
            } else {
                this.createTiles();
            }
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    @Override
    public void createAtlasTbaFile(String name) {
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        this.mapTileWriter = null;
        super.abortAtlasCreation();
    }

    private static class GlopusTile {
        byte[] data;
        double calNLat;
        double calWLon;
        double calSLat;
        double calELon;

        public GlopusTile(byte[] data, double calNLat, double calWLon, double calSLat, double calELon) {
            this.data = data;
            this.calNLat = calNLat;
            this.calWLon = calWLon;
            this.calSLat = calSLat;
            this.calELon = calELon;
        }
    }

    private class GlopusTileWriter
    implements MapTileWriter {
        final LayerInterface layer;
        LinkedList<GlopusTile> tiles;
        int xCoordStart;
        int yCoordStart;
        int tileHeight = 256;
        int tileWidth = 256;
        int zoom;
        MapSpace mapSpace;
        String tileType;

        public GlopusTileWriter(LayerInterface layer) {
            this.layer = layer;
            this.tiles = new LinkedList();
        }

        public void initMap() {
            if (GlopusMapFile.this.parameters != null) {
                this.tileHeight = GlopusMapFile.this.parameters.getHeight();
                this.tileWidth = GlopusMapFile.this.parameters.getWidth();
            }
            this.zoom = GlopusMapFile.this.map.getZoom();
            this.mapSpace = GlopusMapFile.this.mapSource.getMapSpace();
            this.xCoordStart = GlopusMapFile.this.xMin * this.mapSpace.getTileSize();
            this.yCoordStart = GlopusMapFile.this.yMin * this.mapSpace.getTileSize();
        }

        @Override
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            this.tileType = tileType;
            int xCooord = this.xCoordStart + tilex * this.tileWidth;
            int yCooord = this.yCoordStart + tiley * this.tileHeight;
            double calWLon = this.mapSpace.cXToLon(xCooord, this.zoom);
            double calNLat = this.mapSpace.cYToLat(yCooord, this.zoom);
            double calELon = this.mapSpace.cXToLon(xCooord + this.tileWidth, this.zoom);
            double calSLat = this.mapSpace.cYToLat(yCooord + this.tileHeight, this.zoom);
            GlopusTile gt = new GlopusTile(tileData, calNLat, calWLon, calSLat, calELon);
            this.tiles.add(gt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finalizeMap() {
            File gmfFile = new File(GlopusMapFile.this.atlasDir, this.layer.getName() + ".gmf");
            FileOutputStream fout = null;
            try {
                int count = this.tiles.size();
                int offset = 8 + count * 140;
                fout = new FileOutputStream(gmfFile);
                LittleEndianOutputStream out = new LittleEndianOutputStream(new BufferedOutputStream(fout, 16384));
                out.writeInt(-16777214);
                out.writeInt(count);
                int mapNumber = 0;
                Charset charset = Charset.forName("UTF-16LE");
                for (GlopusTile gt : this.tiles) {
                    String mapName = String.format("%08d.%s", mapNumber++, this.tileType);
                    byte[] nameBytes = mapName.getBytes(charset);
                    out.writeInt(mapName.length());
                    out.write(nameBytes);
                    out.writeInt(offset);
                    out.writeInt(this.tileWidth);
                    out.writeInt(this.tileHeight);
                    out.writeInt(4);
                    out.writeInt(0);
                    out.writeInt(0);
                    out.writeDouble(gt.calWLon);
                    out.writeDouble(gt.calNLat);
                    out.writeInt(this.tileHeight);
                    out.writeInt(this.tileWidth);
                    out.writeDouble(gt.calELon);
                    out.writeDouble(gt.calSLat);
                    out.writeInt(this.tileHeight);
                    out.writeInt(0);
                    out.writeDouble(gt.calELon);
                    out.writeDouble(gt.calNLat);
                    out.writeInt(0);
                    out.writeInt(this.tileWidth);
                    out.writeDouble(gt.calWLon);
                    out.writeDouble(gt.calSLat);
                    if (GlopusMapFile.this.log.isTraceEnabled()) {
                        GlopusMapFile.this.log.trace(String.format("Offset %f %f %f %f \"%s\": 0x%x", gt.calWLon, gt.calNLat, gt.calELon, gt.calELon, mapName, offset));
                    }
                    offset += gt.data.length;
                }
                out.flush();
                out = null;
                for (GlopusTile gt : this.tiles) {
                    fout.write(gt.data);
                }
                fout.flush();
                Utilities.closeStream(fout);
            }
            catch (IOException e) {
                GUIExceptionHandler.showExceptionDialog(e);
            }
            finally {
                Utilities.closeStream(fout);
            }
        }
    }
}

