/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.AbstractPlainImage;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ZipStoreOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@AtlasCreatorName(value="Google Earth Overlay (KMZ)", type="GoogleEarthRasterOverlay")
public class GoogleEarthOverlay
extends AbstractPlainImage {
    protected File mapDir;
    protected String cleanedMapName;
    protected File kmzFile = null;
    protected ZipStoreOutputStream kmzOutputStream = null;
    private Document kmlDoc = null;
    private Element groundOverlayRoot = null;

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        Utilities.mkDirs(this.atlasDir);
        this.kmzFile = new File(this.atlasDir, layer.getName() + ".kmz");
        this.kmzOutputStream = new ZipStoreOutputStream(this.kmzFile);
        this.kmzOutputStream.setMethod(0);
        try {
            if (layer.getMapCount() <= 1) {
                this.initKmlDoc(null);
            } else {
                this.initKmlDoc(layer.getName());
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void finishLayerCreation() throws IOException {
        try {
            this.writeKmlToZip();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Utilities.closeStream(this.kmzOutputStream);
        this.kmzOutputStream = null;
        this.kmzFile = null;
        super.finishLayerCreation();
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        Utilities.closeStream(this.kmzOutputStream);
        this.kmzOutputStream = null;
        this.kmzFile = null;
        super.abortAtlasCreation();
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.mapDir = new File(this.atlasDir, map.getLayer().getName());
        this.cleanedMapName = map.getName();
        this.cleanedMapName = this.cleanedMapName.replaceAll("[[^\\p{Alnum}-_]]+", "_");
        this.cleanedMapName = this.cleanedMapName.replaceAll("_{2,}", "_");
        if (this.cleanedMapName.endsWith("_")) {
            this.cleanedMapName = this.cleanedMapName.substring(0, this.cleanedMapName.length() - 1);
        }
        if (this.cleanedMapName.startsWith("_")) {
            this.cleanedMapName = this.cleanedMapName.substring(1, this.cleanedMapName.length());
        }
    }

    @Override
    protected int getBufferedImageType() {
        return 5;
    }

    @Override
    protected void writeTileImage(BufferedImage tileImage) throws MapCreationException {
        TileImageDataWriter writer = this.parameters != null ? this.parameters.getFormat().getDataWriter() : new TileImageJpegDataWriter(0.9);
        writer.initialize();
        try {
            int initialBufferSize = tileImage.getWidth() * tileImage.getHeight() / 4;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(initialBufferSize);
            writer.processImage(tileImage, buf);
            String imageFileName = "files/" + this.cleanedMapName + "." + (Object)((Object)writer.getType());
            this.kmzOutputStream.writeStoredEntry(imageFileName, buf.toByteArray());
            this.addMapToKmz(imageFileName);
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected void addMapToKmz(String imageFileName) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        int startX = this.xMin * this.tileSize;
        int endX = (this.xMax + 1) * this.tileSize;
        int startY = this.yMin * this.tileSize;
        int endY = (this.yMax + 1) * this.tileSize;
        this.addKmlEntry(this.map.getName(), imageFileName, startX, startY, endX - startX, endY - startY);
    }

    private void initKmlDoc(String folderName) throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.kmlDoc = builder.newDocument();
        Element kml = this.kmlDoc.createElementNS("http://www.opengis.net/kml/2.2", "kml");
        this.kmlDoc.appendChild(kml);
        this.groundOverlayRoot = kml;
        if (folderName != null) {
            this.groundOverlayRoot = this.kmlDoc.createElement("Folder");
            kml.appendChild(this.groundOverlayRoot);
            Element name = this.kmlDoc.createElement("name");
            name.setTextContent(folderName);
            Element open = this.kmlDoc.createElement("open");
            open.setTextContent("1");
            this.groundOverlayRoot.appendChild(name);
            this.groundOverlayRoot.appendChild(open);
        }
    }

    private void addKmlEntry(String imageName, String imageFileName, int startX, int startY, int width, int height) {
        Element go = this.kmlDoc.createElement("GroundOverlay");
        Element name = this.kmlDoc.createElement("name");
        Element ico = this.kmlDoc.createElement("Icon");
        Element href = this.kmlDoc.createElement("href");
        Element drawOrder = this.kmlDoc.createElement("drawOrder");
        Element latLonBox = this.kmlDoc.createElement("LatLonBox");
        Element north = this.kmlDoc.createElement("north");
        Element south = this.kmlDoc.createElement("south");
        Element east = this.kmlDoc.createElement("east");
        Element west = this.kmlDoc.createElement("west");
        Element rotation = this.kmlDoc.createElement("rotation");
        name.setTextContent(imageName);
        href.setTextContent(imageFileName);
        drawOrder.setTextContent("0");
        MapSpace mapSpace = this.mapSource.getMapSpace();
        DecimalFormat df = Utilities.FORMAT_6_DEC_ENG;
        String longitudeMin = df.format(mapSpace.cXToLon(startX, this.zoom));
        String longitudeMax = df.format(mapSpace.cXToLon(startX + width, this.zoom));
        String latitudeMin = df.format(mapSpace.cYToLat(startY + height, this.zoom));
        String latitudeMax = df.format(mapSpace.cYToLat(startY, this.zoom));
        north.setTextContent(latitudeMax);
        south.setTextContent(latitudeMin);
        west.setTextContent(longitudeMin);
        east.setTextContent(longitudeMax);
        rotation.setTextContent("0.0");
        this.groundOverlayRoot.appendChild(go);
        go.appendChild(name);
        go.appendChild(ico);
        go.appendChild(latLonBox);
        ico.appendChild(href);
        ico.appendChild(drawOrder);
        latLonBox.appendChild(north);
        latLonBox.appendChild(south);
        latLonBox.appendChild(east);
        latLonBox.appendChild(west);
        latLonBox.appendChild(rotation);
    }

    private void writeKmlToZip() throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16000);
        serializer.transform(new DOMSource(this.kmlDoc), new StreamResult(bos));
        this.kmzOutputStream.writeStoredEntry("doc.kml", bos.toByteArray());
        this.kmlDoc = null;
        this.groundOverlayRoot = null;
    }
}

