/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageType;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="GPS Sports Tracker")
public class GpsSportsTracker
extends AtlasCreator {
    private File mapDir = null;
    protected String appendFileExt = "";

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        String mapName = map.getMapSource().getName().replaceAll(" ", "_");
        this.mapDir = new File(this.atlasDir, mapName);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.mapDir);
        }
        catch (IOException e1) {
            throw new MapCreationException(this.map, (Throwable)e1);
        }
        if (this.mapSource.getTileImageType() != TileImageType.PNG) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, TileImageFormat.PNG);
        }
        this.createTiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    String tileFileName = this.map.getZoom() + "_" + x + "_" + y + ".png";
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    File f = new File(this.mapDir, tileFileName);
                    FileOutputStream out = new FileOutputStream(f);
                    try {
                        out.write(sourceTileData);
                        continue;
                    }
                    finally {
                        Utilities.closeStream(out);
                    }
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }
}

