/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.RMapsSQLite;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageParameters;
import mobac.program.model.TileImageType;

@AtlasCreatorName(value="iPhone 3 Map Tiles v5")
@SupportedParameters(names={})
public class IPhone3MapTiles5
extends RMapsSQLite {
    private static final String INSERT_SQL = "INSERT or REPLACE INTO images(x,y,zoom,data,length,flags) VALUES (?,?,?,?,?,0);";
    private static final String TABLE_IMAGES = "CREATE TABLE IF NOT EXISTS images(zoom int, x int, y int, flags int, length int, data blob); ";
    private static final String TABLE_VERSION = "CREATE TABLE IF NOT EXISTS version(version int);";
    private static final String TABLE_VERSION_DATA = "INSERT INTO version VALUES(5);";
    private static final String INDEX_IMAGES = "CREATE INDEX IF NOT EXISTS index1 on images (zoom,x,y,flags);";

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        EnumSet<TileImageType> allowed = EnumSet.of(TileImageType.JPG, TileImageType.PNG);
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                TileImageType currentTit;
                TileImageParameters parameters = map.getParameters();
                if (parameters == null) {
                    currentTit = map.getMapSource().getTileImageType();
                    if (allowed.contains((Object)currentTit)) continue;
                    throw new AtlasTestException("Map source format incompatible - tile format conversion to PNG or JPG is required for this map.", map);
                }
                currentTit = parameters.getFormat().getType();
                if (allowed.contains((Object)currentTit)) continue;
                throw new AtlasTestException("Selected custom tile format not supported - only JPG and PNG formats are supported.", map);
            }
        }
    }

    @Override
    protected void openConnection() throws SQLException {
        if (this.databaseFile.isFile()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
            this.databaseFile = new File(this.atlasDir, this.atlas.getName() + "_" + sdf.format(new Date()) + ".sqlitedb");
        }
        super.openConnection();
    }

    @Override
    protected void initializeDB() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.executeUpdate(TABLE_IMAGES);
        stat.executeUpdate(INDEX_IMAGES);
        if (stat.executeUpdate(TABLE_VERSION) == 0) {
            stat.execute(TABLE_VERSION_DATA);
        }
        stat.close();
    }

    @Override
    protected void createTiles() throws InterruptedException, MapCreationException {
        try {
            this.parameters = new TileImageParameters(128, 128, TileImageFormat.PNG);
            this.conn.setAutoCommit(false);
            this.prepStmt = this.conn.prepareStatement(this.getTileInsertSQL());
            SQLiteMapTileWriter mapTileWriter = new SQLiteMapTileWriter(this.map);
            MapTileBuilder mapTileBuilder = new MapTileBuilder(this, mapTileWriter, true);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
            mapTileWriter.finalizeMap();
            this.prepStmt.close();
        }
        catch (SQLException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        catch (IOException e) {
            Throwable t = e;
            if (t.getCause() instanceof SQLException) {
                t = t.getCause();
            }
            throw new MapCreationException(this.map, t);
        }
    }

    @Override
    protected void updateTileMetaInfo() throws SQLException {
    }

    @Override
    protected String getTileInsertSQL() {
        return INSERT_SQL;
    }

    @Override
    protected String getDatabaseFileName() {
        return this.atlas.getName() + ".sqlitedb";
    }

    private class SQLiteMapTileWriter
    implements MapTileWriter {
        private final int z;
        private final int baseTileX;
        private final int baseTileY;

        SQLiteMapTileWriter(MapInterface map) {
            this.z = map.getZoom() + 1;
            Point topLeft = map.getMinTileCoordinate();
            this.baseTileX = topLeft.x / 128;
            this.baseTileY = topLeft.y / 128;
        }

        @Override
        public void writeTile(int x, int y, String tileType, byte[] tileData) throws IOException {
            x += this.baseTileX;
            y += this.baseTileY;
            try {
                IPhone3MapTiles5.this.prepStmt.setInt(1, x);
                IPhone3MapTiles5.this.prepStmt.setInt(2, y);
                IPhone3MapTiles5.this.prepStmt.setInt(3, this.z);
                IPhone3MapTiles5.this.prepStmt.setBytes(4, tileData);
                IPhone3MapTiles5.this.prepStmt.setInt(5, tileData.length);
                IPhone3MapTiles5.this.prepStmt.addBatch();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void finalizeMap() throws IOException {
            try {
                IPhone3MapTiles5.this.prepStmt.executeBatch();
                IPhone3MapTiles5.this.prepStmt.clearBatch();
                IPhone3MapTiles5.this.conn.commit();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }
}

