/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.rmp.BoundingRect;
import mobac.program.atlascreators.impl.rmp.MultiImage;
import mobac.program.atlascreators.impl.rmp.RmpLayer;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.atlascreators.impl.rmp.RmpWriter;
import mobac.program.atlascreators.impl.rmp.Tiledata;
import mobac.program.atlascreators.impl.rmp.rmpfile.Bmp2bit;
import mobac.program.atlascreators.impl.rmp.rmpfile.Bmp4bit;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageParameters;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;

@AtlasCreatorName(value="Magellan (RMP)", type="Rmp")
@SupportedParameters(names={TileImageParameters.Name.format_jpg})
public class MagellanRmp
extends AtlasCreator {
    TileImageDataWriter tileWriter = null;
    RmpWriter rmpWriter = null;
    String imageName = null;
    int layerNum = 0;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas, customAtlasDir);
        int mapCount = 0;
        for (LayerInterface layer : atlas) {
            mapCount += layer.getMapCount();
        }
        this.imageName = RmpTools.buildImageName(atlas.getName());
        this.rmpWriter = new RmpWriter(this.imageName, mapCount, new File(this.atlasDir, this.imageName + ".rmp"));
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                Point max = map.getMaxTileCoordinate();
                Point min = map.getMinTileCoordinate();
                if (map.getParameters() == null || map.getParameters().getFormat().getDataWriter() instanceof TileImageJpegDataWriter) continue;
                throw new AtlasTestException("Only JPEG formats are supported", map);
            }
        }
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.tileWriter = this.parameters != null ? this.parameters.getFormat().getDataWriter() : new TileImageJpegDataWriter(0.9);
        this.tileWriter.initialize();
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation(1000);
        ImageIO.setUseCache(false);
        MultiImage layerImage = new MultiImage(this.mapSource, this.mapDlTileProvider, this.map);
        try {
            RmpLayer layer = this.createLayer(layerImage, this.layerNum);
            String layerName = RmpTools.buildTileName(this.imageName, this.layerNum);
            RmpLayer.TLMEntry tlmEntry = layer.getTLMFile(layerName);
            this.rmpWriter.prepareFileEntry(tlmEntry);
            this.rmpWriter.writeFileEntry(layer.getA00File(layerName));
            tlmEntry.updateContent();
            this.rmpWriter.writePreparedFileEntry(tlmEntry);
            this.atlasProgress.setMapCreationProgress(1000);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        ++this.layerNum;
    }

    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        if (this.rmpWriter == null) {
            return;
        }
        try {
            this.rmpWriter.writeFileEntry(new Bmp2bit());
            this.rmpWriter.writeFileEntry(new Bmp4bit());
            this.rmpWriter.writeDirectory();
        }
        finally {
            this.rmpWriter.close();
            this.rmpWriter = null;
        }
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        super.abortAtlasCreation();
        this.rmpWriter.delete();
        this.rmpWriter = null;
    }

    public RmpLayer createLayer(MultiImage si, int layer) throws InterruptedException, MapCreationException, IOException {
        int count = 0;
        RmpLayer rmpLayer = new RmpLayer(this);
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double north = mapSpace.cYToLat(this.map.getMinTileCoordinate().y, this.zoom);
        double south = mapSpace.cYToLat(this.map.getMaxTileCoordinate().y, this.zoom);
        double west = mapSpace.cXToLon(this.map.getMinTileCoordinate().x, this.zoom);
        double east = mapSpace.cXToLon(this.map.getMaxTileCoordinate().x, this.zoom);
        BoundingRect rect = new BoundingRect(-north, -south, west, east);
        Point max = this.map.getMaxTileCoordinate();
        Point min = this.map.getMinTileCoordinate();
        int imageWidth = max.x - min.x;
        int imageHeight = max.y - min.y;
        double tile_width = (rect.getEast() - rect.getWest()) * 256.0 / (double)imageWidth;
        double tile_height = (rect.getSouth() - rect.getNorth()) * 256.0 / (double)imageHeight;
        int x_start = (int)Math.floor((rect.getWest() + 180.0) / tile_width);
        int y_start = (int)Math.floor((rect.getNorth() + 90.0) / tile_height);
        double x_end = (rect.getEast() + 180.0) / tile_width;
        double y_end = (rect.getSouth() + 90.0) / tile_height;
        int x = x_start;
        while ((double)x < x_end) {
            int y = y_start;
            while ((double)y < y_end) {
                ++count;
                BoundingRect subrect = new BoundingRect((double)y * tile_height - 90.0, (double)(y + 1) * tile_height - 90.0, (double)x * tile_width - 180.0, (double)(x + 1) * tile_width - 180.0);
                Tiledata td = new Tiledata(this.tileWriter);
                td.posx = x;
                td.posy = y++;
                td.rect = subrect;
                td.si = si;
                rmpLayer.addPreparedImage(td);
            }
            ++x;
        }
        rmpLayer.buildTLMFile(tile_width, tile_height, rect.getWest(), rect.getEast(), rect.getNorth(), rect.getSouth());
        return rmpLayer;
    }
}

