/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Maplorer atlas format")
@SupportedParameters(names={TileImageParameters.Name.format, TileImageParameters.Name.height, TileImageParameters.Name.width})
public class Maplorer
extends AtlasCreator {
    private static final String FILENAME_PATTERN = "map_%s%d.%s";
    protected File layerFolder = null;
    protected File mapFolder = null;
    protected MapTileWriter mapTileWriter;
    protected int tileXmax = 0;
    protected int tileYmax = 0;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSpace.getProjectionCategory());
    }

    protected void createCustomTiles() throws InterruptedException, MapCreationException {
        this.log.debug("Starting map creation using custom parameters: " + this.parameters);
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            MapTileBuilder mapTileBuilder = new MapTileBuilder(this, this.mapTileWriter, true);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
        }
        finally {
            ctp.cleanup();
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDirs(this.mapFolder);
            this.mapTileWriter = new FileTileWriter();
            if (this.parameters != null) {
                this.createCustomTiles();
            } else {
                this.createTiles();
            }
            this.mapTileWriter.finalizeMap();
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        LayerInterface layer = map.getLayer();
        this.layerFolder = new File(this.atlasDir, layer.getName());
        this.mapFolder = new File(this.layerFolder, map.getName());
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        int tilex = 0;
        int tiley = 0;
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        byte[] emptyTileData = Utilities.createEmptyTileData(this.mapSource);
        String tileType = this.mapSource.getTileImageType().getFileExt();
        for (int x = this.xMin; x <= this.xMax; ++x) {
            tiley = 0;
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData != null) {
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, sourceTileData);
                    } else {
                        this.log.trace(String.format("Tile x=%d y=%d not found in tile archive - creating default", tilex, tiley));
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, emptyTileData);
                    }
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
                ++tiley;
            }
            ++tilex;
        }
    }

    public class FileTileWriter
    implements MapTileWriter {
        File setFolder;
        int tileHeight = 256;
        int tileWidth = 256;

        public FileTileWriter() throws IOException {
            this.setFolder = Maplorer.this.mapFolder;
            Maplorer.this.log.debug("Writing tiles to set folder: " + this.setFolder);
            if (Maplorer.this.parameters != null) {
                this.tileHeight = Maplorer.this.parameters.getHeight();
                this.tileWidth = Maplorer.this.parameters.getWidth();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format(Maplorer.FILENAME_PATTERN, this.IntToLetter(tilex + 1), tiley + 1, imageFormat);
            File f = new File(this.setFolder, tileFileName);
            FileOutputStream out = new FileOutputStream(f);
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
            Maplorer.this.tileXmax = tilex;
            Maplorer.this.tileYmax = tiley;
        }

        private String IntToLetter(int i) throws IOException {
            if (i > 26) {
                throw new IOException("Maximum tile column overflow - map too wide!");
            }
            char c = (char)(i + 64);
            return Character.toString(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finalizeMap() throws IOException {
            MapSpace mapSpace = Maplorer.this.mapSource.getMapSpace();
            double longitudeMin = mapSpace.cXToLon(Maplorer.this.xMin * Maplorer.this.tileSize, Maplorer.this.zoom);
            double longitudeMax = mapSpace.cXToLon((Maplorer.this.xMax + 1) * Maplorer.this.tileSize - 1, Maplorer.this.zoom);
            double latitudeMin = mapSpace.cYToLat((Maplorer.this.yMax + 1) * Maplorer.this.tileSize - 1, Maplorer.this.zoom);
            double latitudeMax = mapSpace.cYToLat(Maplorer.this.yMin * Maplorer.this.tileSize, Maplorer.this.zoom);
            double widthInPixel = Maplorer.this.map.getMaxTileCoordinate().x - Maplorer.this.map.getMinTileCoordinate().x;
            double heihgtInPixel = Maplorer.this.map.getMaxTileCoordinate().y - Maplorer.this.map.getMinTileCoordinate().y;
            double pix2longitude = (longitudeMax - longitudeMin) / widthInPixel;
            double pix2latitude = (latitudeMax - latitudeMin) / heihgtInPixel;
            double lonBL = longitudeMin;
            double latBL = latitudeMax - (double)this.tileHeight * pix2latitude;
            double lonTR = longitudeMin + (double)this.tileWidth * pix2longitude;
            double latTR = latitudeMax;
            for (int tilex = 0; tilex <= Maplorer.this.tileXmax; ++tilex) {
                latBL = latitudeMax - (double)this.tileHeight * pix2latitude;
                latTR = latitudeMax;
                for (int tiley = 0; tiley <= Maplorer.this.tileYmax; ++tiley) {
                    String posFileName = String.format(Maplorer.FILENAME_PATTERN, this.IntToLetter(tilex + 1), tiley + 1, "POS");
                    File posFile = new File(this.setFolder, posFileName);
                    lonBL = Math.max(longitudeMin, lonBL);
                    latBL = Math.max(latitudeMin, latBL);
                    lonTR = Math.min(longitudeMax, lonTR);
                    latTR = Math.min(latitudeMax, latTR);
                    FileWriter outFile = new FileWriter(posFile);
                    try {
                        PrintWriter out2 = new PrintWriter(outFile);
                        String posLine = "LonBL = %2.6f";
                        out2.println(String.format(Locale.ENGLISH, posLine, lonBL));
                        posLine = "LatBL = %2.6f";
                        out2.println(String.format(Locale.ENGLISH, posLine, latBL));
                        posLine = "LonTR = %2.6f";
                        out2.println(String.format(Locale.ENGLISH, posLine, lonTR));
                        posLine = "LatTR = %2.6f";
                        out2.println(String.format(Locale.ENGLISH, posLine, latTR));
                        out2.close();
                    }
                    finally {
                        Utilities.closeWriter(outFile);
                    }
                    latBL -= (double)this.tileHeight * pix2latitude;
                    latTR -= (double)this.tileHeight * pix2latitude;
                }
                lonBL += (double)this.tileWidth * pix2longitude;
                lonTR += (double)this.tileWidth * pix2longitude;
            }
        }
    }
}

