/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageType;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Mobile Trail Explorer Cache", type="MTECache")
public class MobileTrailExplorerCache
extends AtlasCreator {
    protected DataOutputStream cacheOutStream = null;
    protected long lastTileOffset = 0L;
    protected Set<String> availableTileList = new HashSet<String>();

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas, customAtlasDir);
        File cacheFile = new File(this.atlasDir, "MTEFileCache");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cacheFile), 8216);
        this.cacheOutStream = new DataOutputStream(out);
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        Utilities.closeStream(this.cacheOutStream);
        super.abortAtlasCreation();
    }

    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        super.finishAtlasCreation();
        this.cacheOutStream.close();
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        if (this.mapSource.getTileImageType() != TileImageType.PNG) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, TileImageFormat.PNG);
        }
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        String mapName = this.map.getMapSource().getName().replaceAll(" ", "_");
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    this.writeTile(mapName, sourceTileData, x, y, this.zoom);
                    continue;
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }

    protected boolean writeTile(String cache, byte[] tileData, int x, int y, int zoom) throws IOException {
        String url = "not used";
        String cacheKey = cache + "-" + zoom + "-" + x + "-" + y;
        if (this.availableTileList.contains(cacheKey)) {
            this.log.warn("Map tile already in cache: " + cacheKey + " -> ignoring");
            return false;
        }
        this.cacheOutStream.writeInt(x);
        this.cacheOutStream.writeInt(y);
        this.cacheOutStream.writeInt(zoom);
        byte[] urlBytes = url.getBytes();
        this.cacheOutStream.writeShort(urlBytes.length);
        this.cacheOutStream.write(urlBytes);
        byte[] keyBytes = cacheKey.getBytes();
        this.cacheOutStream.writeShort(keyBytes.length);
        this.cacheOutStream.write(keyBytes);
        this.cacheOutStream.writeLong(this.lastTileOffset);
        this.lastTileOffset += (long)(14 + urlBytes.length + 2 + keyBytes.length + 8 + 4 + tileData.length);
        this.cacheOutStream.writeInt(tileData.length);
        this.cacheOutStream.write(tileData);
        return true;
    }
}

