/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.RequiresSQLite;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;
import mobac.utilities.jdbc.SQLiteLoader;

@AtlasCreatorName(value="NaviComputer (NMAP)")
@SupportedParameters(names={TileImageParameters.Name.format})
public class NaviComputer
extends AtlasCreator
implements RequiresSQLite {
    private static final String NAVI_TABLES = "CREATE TABLE  MapInfo (MapType TEXT, Zoom INTEGER NOT NULL, MinX INTEGER, MaxX INTEGER, MinY INTEGER, MaxY INTEGER);\nCREATE TABLE  Tiles (id INTEGER NOT NULL PRIMARY KEY, X INTEGER NOT NULL, Y INTEGER NOT NULL, Zoom INTEGER NOT NULL);\nCREATE TABLE  TilesData (id INTEGER NOT NULL PRIMARY KEY CONSTRAINT fk_Tiles_id REFERENCES Tiles(id) ON DELETE CASCADE, Tile BLOB NULL);\nCREATE TRIGGER fkdc_TilesData_id_Tiles_id BEFORE DELETE ON Tiles FOR EACH ROW BEGIN DELETE FROM TilesData WHERE TilesData.id = OLD.id; END;\nCREATE TRIGGER fki_TilesData_id_Tiles_id BEFORE INSERT ON [TilesData] FOR EACH ROW BEGIN SELECT RAISE(ROLLBACK, 'insert on table TilesData violates foreign key constraint fki_TilesData_id_Tiles_id') WHERE (SELECT id FROM Tiles WHERE id = NEW.id) IS NULL; END;\nCREATE TRIGGER fku_TilesData_id_Tiles_id BEFORE UPDATE ON [TilesData] FOR EACH ROW BEGIN SELECT RAISE(ROLLBACK, 'update on table TilesData violates foreign key constraint fku_TilesData_id_Tiles_id') WHERE (SELECT id FROM Tiles WHERE id = NEW.id) IS NULL; END;\nCREATE INDEX IndexOfTiles ON Tiles (X, Y, Zoom);";
    private static final String INSERT_TILES = "INSERT INTO Tiles (id,X,Y,Zoom) VALUES (?,?,?,?)";
    private static final String INSERT_TILES_DATA = "INSERT  INTO TilesData (id,Tile) VALUES (?,?)";
    private static final String INSERT_MAP_INFO = "INSERT INTO MapInfo (MapType,Zoom,MinX,MaxX,MinY,MaxY) SELECT ?,Min(Zoom),Min(x),Max(x),Min(y),Max(y) FROM Tiles WHERE Zoom=?;";
    private String databaseFile;
    private int wmsTileCount = 1;
    private static final int COMMIT_RATE = 100;
    private int tileCommitCounter = 0;
    protected Connection conn = null;
    private PreparedStatement prepTilesData = null;
    private PreparedStatement prepTiles = null;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        this.performTest_MaxMapZoom(18);
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, AtlasTestException, InterruptedException {
        if (customAtlasDir == null) {
            customAtlasDir = Settings.getInstance().getAtlasOutputDirectory();
        }
        super.startAtlasCreation(atlas, customAtlasDir);
        this.databaseFile = this.getDatabaseFileName();
        this.log.debug("SQLite Database file: " + this.databaseFile);
        try {
            SQLiteLoader.loadSQLite();
        }
        catch (SQLException e) {
            throw new IOException(SQLiteLoader.getMsgSqliteMissing(), e);
        }
        try {
            Utilities.mkDir(this.atlasDir);
            this.openConnection();
            this.initializeDB();
            this.prepTilesData = this.conn.prepareStatement(INSERT_TILES_DATA);
            this.prepTiles = this.conn.prepareStatement(INSERT_TILES);
        }
        catch (SQLException e) {
            throw new AtlasTestException("Error creating SQL database \"" + this.databaseFile + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        if (this.parameters != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
        }
        this.createTiles();
    }

    private void openConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            String url = "jdbc:sqlite:/" + this.databaseFile;
            this.conn = DriverManager.getConnection(url);
        }
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.abortAtlasCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        String mapName = this.mapSource.getName();
        try {
            PreparedStatement prepStat = this.conn.prepareStatement(INSERT_MAP_INFO);
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT Distinct Zoom From Tiles");
            while (rs.next()) {
                int zoom = rs.getInt(1);
                prepStat.setString(1, mapName);
                prepStat.setInt(2, zoom);
                prepStat.execute();
            }
            this.conn.commit();
            prepStat.close();
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
        finally {
            SQLiteLoader.closeConnection(this.conn);
            this.conn = null;
        }
        super.finishAtlasCreation();
    }

    protected void initializeDB() throws SQLException {
        String[] sqlList;
        Statement stat = this.conn.createStatement();
        for (String sql : sqlList = NAVI_TABLES.split("\\n")) {
            stat.addBatch(sql);
        }
        stat.executeBatch();
        stat.close();
        this.log.debug("Database initialization complete: tables, trigges and index created");
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        int maxMapProgress = (this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1);
        this.atlasProgress.initMapCreation(maxMapProgress);
        try {
            this.tileCommitCounter = 0;
            this.conn.setAutoCommit(false);
            Runtime r = Runtime.getRuntime();
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData == null) continue;
                        ++this.tileCommitCounter;
                        this.writeTile(this.wmsTileCount++, x, y, this.zoom, sourceTileData);
                        long heapAvailable = r.maxMemory() - r.totalMemory() + r.freeMemory();
                        if (heapAvailable >= 0x1400000L && this.tileCommitCounter <= 100) continue;
                        this.conn.commit();
                        this.tileCommitCounter = 0;
                        System.gc();
                        continue;
                    }
                    catch (IOException e) {
                        throw new MapCreationException(this.map, (Throwable)e);
                    }
                }
            }
            this.conn.commit();
            this.atlasProgress.setMapCreationProgress(maxMapProgress);
        }
        catch (SQLException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected void writeTile(int id, int x, int y, int z, byte[] tileData) throws SQLException, IOException {
        this.prepTiles.setInt(1, id);
        this.prepTiles.setInt(2, x);
        this.prepTiles.setInt(3, y);
        this.prepTiles.setInt(4, z);
        this.prepTiles.execute();
        this.prepTilesData.setInt(1, id);
        this.prepTilesData.setBytes(2, tileData);
        this.prepTilesData.execute();
    }

    protected String getDatabaseFileName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss_");
        this.databaseFile = new File(this.atlasDir, sdf.format(new Date()) + this.atlas.getName() + ".nmap").getAbsolutePath();
        return this.databaseFile;
    }
}

