/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="OSMTracker tile storage")
@SupportedParameters(names={TileImageParameters.Name.format})
public class OSMTracker
extends AtlasCreator {
    protected String tileFileNamePattern = "%d/%d/%d.%s";
    protected File mapDir = null;
    protected String tileType = null;
    protected MapTileWriter mapTileWriter = null;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.mapDir = new File(this.atlasDir, map.getMapSource().getName());
        this.tileType = this.mapSource.getTileImageType().getFileExt();
        if (this.parameters != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
            this.tileType = this.parameters.getFormat().getFileExt();
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        if (this.mapTileWriter == null) {
            this.mapTileWriter = new OSMTileWriter();
        }
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    this.mapTileWriter.writeTile(x, y, this.tileType, sourceTileData);
                    continue;
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }

    protected class OSMTileWriter
    implements MapTileWriter {
        protected OSMTileWriter() {
        }

        @Override
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            File file = new File(OSMTracker.this.mapDir, String.format(OSMTracker.this.tileFileNamePattern, OSMTracker.this.zoom, tilex, tiley, tileType));
            this.writeTile(file, tileData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeTile(File file, byte[] tileData) throws IOException {
            Utilities.mkDirs(file.getParentFile());
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
        }

        @Override
        public void finalizeMap() throws IOException {
        }
    }
}

