/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="OruxMaps")
@SupportedParameters(names={TileImageParameters.Name.format})
public class OruxMaps
extends AtlasCreator {
    protected static final String ORUXMAPS_EXT = ".otrk2.xml";
    protected static final int TILE_SIZE = 512;
    protected String calVersionCode = "2.1";
    protected static final Color BG_COLOR = new Color(203, 211, 243);
    protected File oruxMapsMainDir;
    protected File oruxMapsLayerDir;
    protected File oruxMapsImagesDir;
    protected LayerInterface currentLayer;
    protected String mapName;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return mapSource.getMapSpace() instanceof MercatorPower2MapSpace;
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            int cont = layer.getMapCount();
            for (int i = 0; i < cont; ++i) {
                MapInterface currMap = layer.getMap(i);
                int currZoomLevel = currMap.getZoom();
                for (int j = i + 1; j < cont; ++j) {
                    MapInterface nextMap = layer.getMap(j);
                    int nextZoomLevel = nextMap.getZoom();
                    if (currZoomLevel != nextZoomLevel) continue;
                    throw new AtlasTestException("Unable to create a map with more than a layer with the same zoom level: " + currMap + " & " + nextMap + "\nPossible causes:\nYou are combining several layers (using drag & drop in 'Atlas Content')\nYou are creating a large map, and you have not selected the maximum value in 'Settings - Map size'");
                }
            }
        }
    }

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.currentLayer = layer;
        this.oruxMapsMainDir = new File(this.atlasDir, layer.getName());
        Utilities.mkDirs(this.oruxMapsMainDir);
    }

    @Override
    public void finishLayerCreation() throws IOException {
        super.finishLayerCreation();
        this.writeMainOtrk2File(this.currentLayer.getName());
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.parameters = this.parameters == null ? new TileImageParameters(512, 512, TileImageFormat.JPEG90) : new TileImageParameters(512, 512, this.parameters.getFormat());
        this.mapName = String.format("%s %02d", this.currentLayer.getName(), map.getZoom());
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.oruxMapsLayerDir = new File(this.oruxMapsMainDir, this.mapName);
        this.oruxMapsImagesDir = new File(this.oruxMapsLayerDir, "set");
        try {
            Utilities.mkDirs(this.oruxMapsImagesDir);
            this.writeOtrk2File();
            this.createTiles();
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            OruxMapTileBuilder mapTileBuilder = new OruxMapTileBuilder(this, new OruxMapTileWriter());
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
        }
        finally {
            ctp.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMainOtrk2File(String name) {
        OutputStream otrk2FileStream = null;
        File otrk2 = new File(this.oruxMapsMainDir, name + ORUXMAPS_EXT);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(otrk2), StandardCharsets.UTF_8);
            writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.append("<OruxTracker xmlns=\"http://oruxtracker.com/app/res/calibration\"\n versionCode=\"" + this.calVersionCode + "\">\n");
            writer.append("<MapCalibration layers=\"true\" layerLevel=\"0\">\n");
            writer.append("<MapName><![CDATA[" + name + "]]></MapName>\n");
            writer.append(this.appendMapContent());
            writer.append("</MapCalibration>\n");
            writer.append("</OruxTracker>\n");
            writer.flush();
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        finally {
            Utilities.closeStream(otrk2FileStream);
        }
    }

    protected String appendMapContent() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOtrk2File() {
        FileOutputStream stream = null;
        File otrk2File = new File(this.oruxMapsLayerDir, this.mapName + ORUXMAPS_EXT);
        try {
            stream = new FileOutputStream(otrk2File);
            OutputStreamWriter mapWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
            mapWriter.append(this.prepareOtrk2File());
            mapWriter.flush();
        }
        catch (IOException e) {
            try {
                this.log.error("", e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(stream);
                throw throwable;
            }
            Utilities.closeStream(stream);
        }
        Utilities.closeStream(stream);
    }

    protected String prepareOtrk2File() {
        StringBuilder mapWriter = new StringBuilder();
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
        double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize, this.zoom);
        double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize, this.zoom);
        double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
        mapWriter.append("<OruxTracker xmlns=\"http://oruxtracker.com/app/res/calibration\"\n versionCode=\"2.1\">\n");
        mapWriter.append("<MapCalibration layers=\"false\" layerLevel=\"" + this.map.getZoom() + "\">\n");
        mapWriter.append("<MapName><![CDATA[" + this.mapName + "]]></MapName>\n");
        String mapFileName = this.mapName;
        mapFileName = mapFileName.replaceAll("&", "&amp;");
        mapFileName = mapFileName.replaceAll("<", "&lt;");
        mapFileName = mapFileName.replaceAll(">", "&gt;");
        mapFileName = mapFileName.replaceAll("\"", "&quot;");
        mapFileName = mapFileName.replaceAll("'", "&apos;");
        int mapWidth = (this.xMax - this.xMin + 1) * this.tileSize;
        int mapHeight = (this.yMax - this.yMin + 1) * this.tileSize;
        int numXimg = (mapWidth + 512 - 1) / 512;
        int numYimg = (mapHeight + 512 - 1) / 512;
        mapWriter.append("<MapChunks xMax=\"" + numXimg + "\" yMax=\"" + numYimg + "\" datum=\"WGS84\" projection=\"Mercator\" img_height=\"" + 512 + "\" img_width=\"" + 512 + "\" file_name=\"" + mapFileName + "\" />\n");
        mapWriter.append("<MapDimensions height=\"" + mapHeight + "\" width=\"" + mapWidth + "\" />\n");
        mapWriter.append("<MapBounds minLat=\"" + latitudeMin + "\" maxLat=\"" + latitudeMax + "\" minLon=\"" + longitudeMin + "\" maxLon=\"" + longitudeMax + "\" />\n");
        mapWriter.append("<CalibrationPoints>\n");
        String cb = "<CalibrationPoint corner=\"%s\" lon=\"%2.6f\" lat=\"%2.6f\" />\n";
        mapWriter.append(String.format(Locale.ENGLISH, cb, "TL", longitudeMin, latitudeMax));
        mapWriter.append(String.format(Locale.ENGLISH, cb, "BR", longitudeMax, latitudeMin));
        mapWriter.append(String.format(Locale.ENGLISH, cb, "TR", longitudeMax, latitudeMax));
        mapWriter.append(String.format(Locale.ENGLISH, cb, "BL", longitudeMin, latitudeMin));
        mapWriter.append("</CalibrationPoints>\n");
        mapWriter.append("</MapCalibration>\n");
        mapWriter.append("</OruxTracker>\n");
        return mapWriter.toString();
    }

    private class OruxMapTileWriter
    implements MapTileWriter {
        private OruxMapTileWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            String tileFileName = String.format("%s_%d_%d.omc2", OruxMaps.this.mapName, tilex, tiley);
            FileOutputStream out = new FileOutputStream(new File(OruxMaps.this.oruxMapsImagesDir, tileFileName));
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
        }

        @Override
        public void finalizeMap() {
        }
    }

    protected class OruxMapTileBuilder
    extends MapTileBuilder {
        public OruxMapTileBuilder(AtlasCreator atlasCreator, MapTileWriter mapTileWriter) {
            super(atlasCreator, mapTileWriter, false);
        }

        @Override
        protected void prepareTile(Graphics2D graphics) {
            graphics.setColor(BG_COLOR);
            graphics.fillRect(0, 0, 512, 512);
        }
    }
}

