/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.OruxMaps;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.RequiresSQLite;
import mobac.utilities.jdbc.SQLiteLoader;

@AtlasCreatorName(value="OruxMaps Sqlite")
public class OruxMapsSqlite
extends OruxMaps
implements RequiresSQLite {
    private static final String TABLE_TILES_DDL = "CREATE TABLE IF NOT EXISTS tiles (x int, y int, z int, image blob, PRIMARY KEY (x,y,z))";
    private static final String INDEX_DDL = "CREATE INDEX IF NOT EXISTS IND on tiles (x,y,z)";
    private static final String INSERT_SQL = "INSERT or IGNORE INTO tiles (x,y,z,image) VALUES (?,?,?,?)";
    private static final String TABLE_ANDROID_METADATA_DDL = "CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)";
    private static final String DATABASE_FILENAME = "OruxMapsImages.db";
    private String databaseFile;
    private Connection conn = null;
    private PreparedStatement prepStmt;
    private StringBuilder otrk2MapsContent;

    public OruxMapsSqlite() {
        SQLiteLoader.loadSQLiteOrShowError();
        this.calVersionCode = "3.0";
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws AtlasTestException, IOException, InterruptedException {
        super.startAtlasCreation(atlas, customAtlasDir);
        try {
            SQLiteLoader.loadSQLite();
        }
        catch (SQLException e) {
            throw new AtlasTestException(SQLiteLoader.getMsgSqliteMissing(), e);
        }
    }

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.databaseFile = new File(this.oruxMapsMainDir, DATABASE_FILENAME).getAbsolutePath();
        this.log.debug("SQLite Database file: " + this.databaseFile);
        this.otrk2MapsContent = new StringBuilder();
        try {
            this.conn = this.getConnection();
            this.initializeDB();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        super.finishAtlasCreation();
        this.closeConnection();
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        super.abortAtlasCreation();
        this.log.debug("Aborting OruxMapsSqlite atlas creation");
        this.closeConnection();
    }

    private Connection getConnection() throws SQLException {
        String url = "jdbc:sqlite:/" + this.databaseFile;
        Connection conn = DriverManager.getConnection(url);
        return conn;
    }

    private void closeConnection() {
        try {
            if (this.conn != null) {
                this.log.debug("Closing database connection");
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn = null;
    }

    private void initializeDB() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.executeUpdate(TABLE_TILES_DDL);
        stat.executeUpdate(INDEX_DDL);
        stat.executeUpdate(TABLE_ANDROID_METADATA_DDL);
        stat.executeUpdate("INSERT INTO android_metadata VALUES ('" + Locale.getDefault().toString() + "')");
        stat.close();
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.otrk2MapsContent.append(this.prepareOtrk2File());
        try {
            this.conn = this.getConnection();
            this.conn.setAutoCommit(false);
            this.prepStmt = this.conn.prepareStatement(INSERT_SQL);
            this.createTiles();
            this.conn.close();
        }
        catch (InterruptedException e) {
            return;
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    @Override
    protected void createTiles() throws InterruptedException, MapCreationException {
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            OruxMapTileWriterDB mtw = new OruxMapTileWriterDB();
            OruxMaps.OruxMapTileBuilder mapTileBuilder = new OruxMaps.OruxMapTileBuilder(this, mtw);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
            mtw.finalizeMap();
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        finally {
            ctp.cleanup();
        }
    }

    @Override
    protected String appendMapContent() {
        return this.otrk2MapsContent.toString();
    }

    private class OruxMapTileWriterDB
    implements MapTileWriter {
        private int tileCounter = 0;
        private Runtime r = Runtime.getRuntime();

        private OruxMapTileWriterDB() {
        }

        @Override
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            try {
                OruxMapsSqlite.this.prepStmt.setInt(1, tilex);
                OruxMapsSqlite.this.prepStmt.setInt(2, tiley);
                OruxMapsSqlite.this.prepStmt.setInt(3, OruxMapsSqlite.this.zoom);
                OruxMapsSqlite.this.prepStmt.setBytes(4, tileData);
                OruxMapsSqlite.this.prepStmt.addBatch();
                long heapAvailable = this.r.maxMemory() - this.r.totalMemory() + this.r.freeMemory();
                ++this.tileCounter;
                if (heapAvailable < 0x1400000L || this.tileCounter > 1000) {
                    this.commit();
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        private void commit() throws SQLException {
            OruxMapsSqlite.this.prepStmt.executeBatch();
            OruxMapsSqlite.this.prepStmt.clearBatch();
            OruxMapsSqlite.this.atlasProgress.incMapCreationProgress(this.tileCounter);
            this.tileCounter = 0;
            OruxMapsSqlite.this.conn.commit();
            System.gc();
        }

        @Override
        public void finalizeMap() throws IOException {
            try {
                this.commit();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }
}

