/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.OSMTracker;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.Settings;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ZipStoreOutputStream;

@AtlasCreatorName(value="Osmdroid ZIP")
public class Osmdroid
extends OSMTracker {
    protected ZipStoreOutputStream zipStream = null;
    protected String currentMapStoreName = null;

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.createTiles();
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws AtlasTestException, IOException, InterruptedException {
        if (customAtlasDir == null) {
            customAtlasDir = Settings.getInstance().getAtlasOutputDirectory();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String atlasDirName = atlas.getName() + "_" + sdf.format(new Date());
        super.startAtlasCreation(atlas, customAtlasDir);
        this.zipStream = new ZipStoreOutputStream(new File(this.atlasDir, atlasDirName + ".zip"));
        this.mapTileWriter = new OSMDroidTileWriter();
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        Utilities.closeStream(this.zipStream);
        super.abortAtlasCreation();
    }

    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        Utilities.closeStream(this.zipStream);
        super.finishAtlasCreation();
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.currentMapStoreName = map.getMapSource().getName();
        if (this.currentMapStoreName.equals("TilesAtHome")) {
            this.currentMapStoreName = "Osmarender";
        } else if (this.currentMapStoreName.equals("OSM Cycle Map")) {
            this.currentMapStoreName = "CycleMap";
        }
    }

    private class OSMDroidTileWriter
    implements MapTileWriter {
        private OSMDroidTileWriter() {
        }

        @Override
        public void finalizeMap() throws IOException {
        }

        @Override
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            String tileName = Osmdroid.this.currentMapStoreName + "/" + String.format(Osmdroid.this.tileFileNamePattern, Osmdroid.this.zoom, tilex, tiley, tileType);
            Osmdroid.this.zipStream.writeStoredEntry(tileName, tileData);
        }
    }
}

