/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.Utilities;
import mobac.utilities.geo.GeoUtils;
import mobac.utilities.imageio.PngXxlWriter;

@AtlasCreatorName(value="OziExplorer (PNG & MAP)", type="OziPng")
@SupportedParameters(names={})
public class Ozi
extends AtlasCreator {
    protected File layerDir = null;
    protected String mapName = null;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSpace.getProjectionCategory());
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.layerDir = new File(this.atlasDir, map.getLayer().getName());
        this.mapName = map.getName();
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.layerDir);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        this.createTiles();
        this.writeMapFile();
    }

    protected void writeMapFile() {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, this.mapName + ".map"));
            this.writeMapFile(this.map.getName() + ".png", fout);
            Utilities.closeStream(fout);
        }
        catch (Exception e) {
            this.log.error("", e);
        }
        finally {
            Utilities.closeStream(fout);
        }
    }

    protected void writeMapFile(String imageFileName, OutputStream stream) throws IOException {
        this.log.trace("Writing map file");
        OutputStreamWriter mapWriter = new OutputStreamWriter(stream, TEXT_FILE_CHARSET);
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
        double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        double midLat = Math.toRadians((latitudeMax + latitudeMin) / 2.0);
        double rlonMax = Math.toRadians(longitudeMax);
        double rlonMin = Math.toRadians(longitudeMin);
        double Lon50 = 50.0 / (double)width * Math.abs(rlonMax - rlonMin);
        double midLon = (rlonMax + rlonMin) / 2.0;
        double lonW = midLon - Lon50;
        double lonE = midLon + Lon50;
        double mDistA = Math.cos(midLat);
        double mDistB = Math.sin((lonW - lonE) / 2.0);
        double mDist = 2.0 * Math.asin(Math.sqrt(mDistA * mDistA * mDistB * mDistB));
        double mm1b = 6399592.0 * mDist / 100.0;
        mapWriter.write(this.prepareMapString(imageFileName, longitudeMin, longitudeMax, latitudeMin, latitudeMax, width, height, mm1b));
        mapWriter.flush();
    }

    protected String prepareMapString(String fileName, double longitudeMin, double longitudeMax, double latitudeMin, double latitudeMax, int width, int height, double mm1b) {
        StringBuffer sbMap = new StringBuffer();
        sbMap.append("OziExplorer Map Data File Version 2.2\r\n");
        sbMap.append(fileName + "\r\n");
        sbMap.append(fileName + "\r\n");
        sbMap.append("1 ,Map Code,\r\n");
        sbMap.append("WGS 84,WGS 84,   0.0000,   0.0000,WGS 84\r\n");
        sbMap.append("Reserved 1\r\n");
        sbMap.append("Reserved 2\r\n");
        sbMap.append("Magnetic Variation,,,E\r\n");
        sbMap.append("Map Projection,Mercator,PolyCal,No,AutoCalOnly,No,BSBUseWPX,No\r\n");
        String latMax = GeoUtils.getDegMinFormat(latitudeMax, true);
        String latMin = GeoUtils.getDegMinFormat(latitudeMin, true);
        String lonMax = GeoUtils.getDegMinFormat(longitudeMax, false);
        String lonMin = GeoUtils.getDegMinFormat(longitudeMin, false);
        String pointLine = "Point%02d,xy, %4s, %4s,in, deg, %1s, %1s, grid, , , ,N\r\n";
        sbMap.append(String.format(pointLine, 1, 0, 0, latMax, lonMin));
        sbMap.append(String.format(pointLine, 2, width - 1, 0, latMax, lonMax));
        sbMap.append(String.format(pointLine, 3, width - 1, height - 1, latMin, lonMax));
        sbMap.append(String.format(pointLine, 4, 0, height - 1, latMin, lonMin));
        for (int i = 5; i <= 30; ++i) {
            String s = String.format(pointLine, i, "", "", "", "");
            sbMap.append(s);
        }
        sbMap.append("Projection Setup,,,,,,,,,,\r\n");
        sbMap.append("Map Feature = MF ; Map Comment = MC     These follow if they exist\r\n");
        sbMap.append("Track File = TF      These follow if they exist\r\n");
        sbMap.append("Moving Map Parameters = MM?    These follow if they exist\r\n");
        sbMap.append("MM0,Yes\r\n");
        sbMap.append("MMPNUM,4\r\n");
        String mmpxLine = "MMPXY, %d, %5d, %5d\r\n";
        sbMap.append(String.format(mmpxLine, 1, 0, 0));
        sbMap.append(String.format(mmpxLine, 2, width - 1, 0));
        sbMap.append(String.format(mmpxLine, 3, width - 1, height - 1));
        sbMap.append(String.format(mmpxLine, 4, 0, height - 1));
        String mpllLine = "MMPLL, %d, %2.6f, %2.6f\r\n";
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 1, longitudeMin, latitudeMax));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 2, longitudeMax, latitudeMax));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 3, longitudeMax, latitudeMin));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 4, longitudeMin, latitudeMin));
        sbMap.append("MOP,Map Open Position,0,0\r\n");
        sbMap.append(String.format(Locale.ENGLISH, "MM1B, %2.6f\r\n", mm1b));
        sbMap.append("IWH,Map Image Width/Height, " + width + ", " + height + "\r\n");
        return sbMap.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        int tileLineHeight = this.tileSize;
        FileOutputStream fileOs = null;
        Color backgroundColor = this.mapSource.getBackgroundColor();
        try {
            fileOs = new FileOutputStream(new File(this.layerDir, this.mapName + ".png"));
            PngXxlWriter pngWriter = new PngXxlWriter(width, height, fileOs);
            for (int y = this.yMin; y <= this.yMax; ++y) {
                BufferedImage lineImage = new BufferedImage(width, tileLineHeight, 1);
                Graphics2D graphics = lineImage.createGraphics();
                try {
                    graphics.setColor(backgroundColor);
                    graphics.fillRect(0, 0, width, tileLineHeight);
                    int lineX = 0;
                    for (int x = this.xMin; x <= this.xMax; ++x) {
                        this.checkUserAbort();
                        this.atlasProgress.incMapCreationProgress();
                        BufferedImage tile = this.mapDlTileProvider.getTileImage(x, y);
                        if (tile != null) {
                            graphics.drawImage(tile, lineX, 0, backgroundColor, null);
                        }
                        lineX += this.tileSize;
                    }
                }
                finally {
                    graphics.dispose();
                }
                pngWriter.writeTileLine(lineImage);
            }
            pngWriter.finish();
        }
        catch (IOException e) {
            try {
                throw new MapCreationException(this.map, (Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fileOs);
                throw throwable;
            }
        }
        Utilities.closeStream(fileOs);
    }
}

