/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import mobac.exceptions.MapCreationException;
import mobac.gui.mapview.ScaleBar;
import mobac.gui.mapview.WgsGrid;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.Settings;
import mobac.program.model.SettingsPaperAtlas;
import mobac.program.model.SettingsWgsGrid;
import mobac.program.model.UnitSystem;
import mobac.utilities.Utilities;

public abstract class PaperAtlas
extends AtlasCreator {
    private static final Font PAGE_NUMBER_FONT = new Font("SansSerif", 1, 24);
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Color LABEL_BACKGROUND = new Color(0, 127, 0);
    private static final Color LABEL_FOREGROUND = Color.WHITE;
    private static final Color IMAGE_BACKGROUND = new Color(0, 0, 0, 0);
    private static final String UP = " \u2191";
    private static final String DOWN = " \u2193";
    private final JComponent dummy = new JPanel();
    private final WgsGrid wgsGrid;
    private final int overlap;
    private final Insets insets = new Insets(0, 0, 0, 0);
    protected final SettingsPaperAtlas s;
    private int tileImageScale = 1;
    private File layerFolder;
    private Dimension base;
    private Dimension bottom;
    private Dimension right;
    private Dimension corner;

    protected PaperAtlas(boolean usePadding) {
        this.s = Settings.getInstance().paperAtlas.clone();
        this.overlap = (int)UnitSystem.pointsToPixels(this.s.overlap, this.s.dpi);
        if (this.s.wgsEnabled) {
            SettingsWgsGrid sWgsGrid = Settings.getInstance().wgsGrid.clone();
            sWgsGrid.enabled = this.s.wgsEnabled;
            sWgsGrid.density = this.s.wgsDensity;
            this.wgsGrid = new WgsGrid(sWgsGrid, this.dummy);
        } else {
            this.wgsGrid = null;
        }
        if (usePadding) {
            this.insets.top = (int)UnitSystem.pointsToPixels(this.s.marginTop, this.s.dpi);
            this.insets.left = (int)UnitSystem.pointsToPixels(this.s.marginLeft, this.s.dpi);
            this.insets.bottom = (int)UnitSystem.pointsToPixels(this.s.marginBottom, this.s.dpi);
            this.insets.right = (int)UnitSystem.pointsToPixels(this.s.marginTop, this.s.dpi);
        }
        if (this.s.paperSize != null) {
            double width = this.s.paperSize.width - this.s.marginLeft - this.s.marginRight;
            double height = this.s.paperSize.height - this.s.marginTop - this.s.marginBottom;
            width = UnitSystem.pointsToPixels(width, this.s.dpi);
            height = UnitSystem.pointsToPixels(height, this.s.dpi);
            this.base = new Dimension((int)width, (int)height);
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.bottom = null;
        this.right = null;
        this.corner = null;
        this.tileImageScale = this.getTileImageScale();
        int mapWidth = (this.xMax - this.xMin + 1) * this.tileSize * this.tileImageScale;
        int mapHeight = (this.yMax - this.yMin + 1) * this.tileSize * this.tileImageScale;
        if (this.base == null) {
            this.base = new Dimension(mapWidth, mapHeight);
            this.processPages(1, 1);
            this.base = null;
        } else {
            int sHeight;
            int sWidth = mapWidth % (this.base.width - this.overlap);
            if ((double)sWidth / this.base.getWidth() * 100.0 < (double)this.s.crop) {
                sWidth = 0;
            }
            if ((double)(sHeight = mapHeight % (this.base.height - this.overlap)) / this.base.getHeight() * 100.0 < (double)this.s.crop) {
                sHeight = 0;
            }
            if (sHeight > 0 && sWidth > 0) {
                this.corner = new Dimension(sWidth, sHeight);
            }
            if (sWidth > 0) {
                this.right = new Dimension(sWidth, this.base.height);
            }
            if (sHeight > 0) {
                this.bottom = new Dimension(this.base.width, sHeight);
            }
            int rows = mapHeight / (this.base.height - this.overlap) + (this.bottom != null ? 1 : 0);
            int cols = mapWidth / (this.base.width - this.overlap) + (this.right != null ? 1 : 0);
            this.processPages(rows, cols);
        }
    }

    protected File getLayerFolder() {
        return this.layerFolder;
    }

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.layerFolder = new File(this.atlasDir, layer.getName());
        Utilities.mkDirs(this.layerFolder);
    }

    protected int getTileImageScale() {
        int tileImageScale = 1;
        if (this.mapDlTileProvider == null) {
            return tileImageScale;
        }
        try {
            block2: for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    BufferedImage tile = this.mapDlTileProvider.getTileImage(x, y);
                    if (tile == null) continue;
                    tileImageScale = tile.getWidth() / this.tileSize;
                    continue block2;
                }
            }
            if (tileImageScale != 2) {
                this.log.debug("invalid tile Scale for Paper Atlas " + tileImageScale);
                tileImageScale = 1;
            }
        }
        catch (IOException e) {
            tileImageScale = 1;
        }
        return tileImageScale;
    }

    protected abstract void processPage(BufferedImage var1, int var2) throws MapCreationException;

    private void processPages(int ROWS, int COLS) throws MapCreationException, InterruptedException {
        try {
            this.atlasProgress.initMapCreation(ROWS * COLS * 2);
            for (int row = 0; row < ROWS; ++row) {
                for (int col = 0; col < COLS; ++col) {
                    boolean lastCol;
                    this.log.trace(String.format("cal=%d row=%d", col, row));
                    boolean firstRow = row == 0;
                    boolean lastRow = row + 1 == ROWS;
                    boolean bl = lastCol = col + 1 == COLS;
                    Dimension size = this.corner != null && lastRow && lastCol ? new Dimension(this.corner) : (this.bottom != null && lastRow ? new Dimension(this.bottom) : (this.right != null && lastCol ? new Dimension(this.right) : new Dimension(this.base)));
                    int pageXMin = col * this.base.width - col * this.overlap;
                    int pageYMin = row * this.base.height - row * this.overlap;
                    int firstTileX = pageXMin / (this.tileSize * this.tileImageScale) + this.xMin;
                    int firstTileY = pageYMin / (this.tileSize * this.tileImageScale) + this.yMin;
                    int firstTileXOffset = pageXMin % (this.tileSize * this.tileImageScale);
                    int firstTileYOffset = pageYMin % (this.tileSize * this.tileImageScale);
                    int tilesInCol = (size.height + firstTileYOffset - 1) / (this.tileSize * this.tileImageScale) + 1;
                    int tilesInRow = (size.width + firstTileXOffset - 1) / (this.tileSize * this.tileImageScale) + 1;
                    int imageWidth = size.width + this.insets.left + this.insets.right;
                    int imageHeight = size.height + this.insets.top + this.insets.bottom;
                    BufferedImage image = Utilities.safeCreateBufferedImage(imageWidth, imageHeight, 6);
                    Graphics2D g = image.createGraphics();
                    g.translate(this.insets.left, this.insets.top);
                    g.clipRect(0, 0, size.width, size.height);
                    g.setBackground(IMAGE_BACKGROUND);
                    g.clearRect(0, 0, size.width, size.height);
                    g.translate(-firstTileXOffset, -firstTileYOffset);
                    for (int tileRow = 0; tileRow < tilesInCol; ++tileRow) {
                        for (int tileCol = 0; tileCol < tilesInRow; ++tileCol) {
                            int tileX = firstTileX + tileCol;
                            int tileY = firstTileY + tileRow;
                            int x = tileCol * this.tileSize * this.tileImageScale;
                            int y = tileRow * this.tileSize * this.tileImageScale;
                            BufferedImage tile = this.mapDlTileProvider.getTileImage(tileX, tileY);
                            if (tile == null) continue;
                            g.drawImage(tile, x, y, this.tileSize * this.tileImageScale, this.tileSize * this.tileImageScale, null);
                        }
                    }
                    g.translate(firstTileXOffset, firstTileYOffset);
                    this.dummy.setSize(size);
                    Point tlc = new Point(firstTileX * this.tileSize * this.tileImageScale + firstTileXOffset, firstTileY * this.tileSize * this.tileImageScale + firstTileYOffset);
                    if (this.s.wgsEnabled) {
                        this.wgsGrid.paintWgsGrid(g, this.mapSource.getMapSpace(), tlc, this.zoom);
                    }
                    if (this.s.scaleBar) {
                        ScaleBar.paintScaleBar(this.dummy, g, this.mapSource.getMapSpace(), tlc, this.zoom);
                    }
                    if (this.s.compass) {
                        BufferedImage compassRaw = ImageIO.read(Utilities.loadResourceAsStream("images/compass.png"));
                        Image compass = compassRaw.getScaledInstance(150, 150, 4);
                        g.drawImage(compass, 0, 0, null);
                    }
                    if (this.s.pageNumbers) {
                        int stringWidth;
                        String text;
                        g.setBackground(LABEL_BACKGROUND);
                        g.setColor(LABEL_FOREGROUND);
                        String pageNumber = " " + this.getPageNumber(row, col, ROWS, COLS) + " ";
                        g.setFont(PAGE_NUMBER_FONT);
                        FontMetrics fontMetrics = g.getFontMetrics();
                        int fontHeight = fontMetrics.getHeight();
                        int pageNumberStringWidth = fontMetrics.stringWidth(pageNumber);
                        g.clearRect(0, 0, pageNumberStringWidth, fontHeight);
                        g.drawString(pageNumber, 0, fontHeight - fontMetrics.getDescent());
                        int centerX = size.width / 2;
                        g.setFont(LABEL_FONT);
                        fontMetrics = g.getFontMetrics();
                        fontHeight = fontMetrics.getHeight();
                        if (!firstRow) {
                            text = UP + this.getPageNumber(row - 1, col, ROWS, COLS) + " ";
                            stringWidth = fontMetrics.stringWidth(text);
                            g.clearRect(centerX - stringWidth / 2, 8, stringWidth, fontHeight);
                            g.drawString(text, centerX - stringWidth / 2, 8 + fontHeight - fontMetrics.getDescent());
                        }
                        if (!lastRow) {
                            text = DOWN + this.getPageNumber(row + 1, col, ROWS, COLS) + " ";
                            stringWidth = fontMetrics.stringWidth(text);
                            g.clearRect(centerX - stringWidth / 2, size.height - 32 - fontHeight, stringWidth, fontHeight);
                            g.drawString(text, centerX - stringWidth / 2, size.height - 32 - fontMetrics.getDescent());
                        }
                    }
                    g.dispose();
                    this.atlasProgress.incMapCreationProgress();
                    this.checkUserAbort();
                    this.processPage(image, this.getPageNumber(row, col, ROWS, COLS));
                    this.atlasProgress.incMapCreationProgress();
                    this.checkUserAbort();
                }
            }
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    private int getPageNumber(int row, int col, int ROWS, int COLS) {
        return row * COLS + col + 1;
    }

    @Override
    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        MapSpace.ProjectionCategory projection = mapSpace.getProjectionCategory();
        return mapSpace instanceof MercatorPower2MapSpace && (MapSpace.ProjectionCategory.SPHERE.equals((Object)projection) || MapSpace.ProjectionCategory.ELLIPSOID.equals((Object)projection));
    }

    protected static class Page {
        protected final BufferedImage image;
        protected final int number;
        protected final int width;
        protected final int height;

        protected Page(int number, BufferedImage image) {
            this.number = number;
            this.image = image;
            this.width = image.getWidth();
            this.height = image.getHeight();
        }
    }
}

