/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.PaperAtlas;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Paper Atlas (PNG)")
public class PaperAtlasPng
extends PaperAtlas {
    private final DecimalFormat decimalFormat = new DecimalFormat("#000");
    private File mapFolder;

    public PaperAtlasPng() {
        super(true);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.mapFolder = new File(this.getLayerFolder(), this.map.getName());
        try {
            Utilities.mkDirs(this.mapFolder);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        super.createMap();
        this.mapFolder = null;
    }

    @Override
    protected void processPage(BufferedImage image, int pageNumber) throws MapCreationException {
        String fileName = this.decimalFormat.format(pageNumber) + ".png";
        File file = new File(this.mapFolder, fileName);
        try {
            ImageIO.write((RenderedImage)image, "PNG", file);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }
}

