/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.OSMTracker;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;

@AtlasCreatorName(value="PathAway tile cache")
public class PathAway
extends OSMTracker {
    public PathAway() {
        this.tileFileNamePattern = "%02X/%04X/%04X.%s";
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        MapSource mapSource = map.getMapSource();
        String shortMapDir = null;
        if (mapSource.getName().equals("Google Maps")) {
            shortMapDir = "G1";
        } else if (mapSource.getName().equals("Google Earth")) {
            shortMapDir = "G2";
        } else if (mapSource.getName().equals("Google Terrain")) {
            shortMapDir = "G3";
        } else if (mapSource.getName().equals("Mapnik")) {
            shortMapDir = "OSM1";
        } else if (mapSource.getName().equals("OSM Cycle Map")) {
            shortMapDir = "OCM1";
        }
        if (shortMapDir != null) {
            this.mapDir = new File(this.atlasDir, shortMapDir);
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        if (this.mapTileWriter == null) {
            this.mapTileWriter = new PathAwayTileWriter();
        }
        this.createTiles();
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                if (map.getZoom() <= 17) continue;
                throw new AtlasTestException("resolution too high - highest possible zoom level is 17");
            }
        }
    }

    protected class PathAwayTileWriter
    extends OSMTracker.OSMTileWriter {
        protected PathAwayTileWriter() {
        }

        @Override
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            File file = new File(PathAway.this.mapDir, String.format(PathAway.this.tileFileNamePattern, 17 - PathAway.this.zoom, tilex, tiley, tileType));
            this.writeTile(file, tileData);
        }
    }
}

