/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AbstractSQLite;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="RMaps SQLite", type="RMaps")
@SupportedParameters(names={TileImageParameters.Name.format})
public class RMapsSQLite
extends AbstractSQLite {
    private static final String TABLE_DDL = "CREATE TABLE IF NOT EXISTS tiles (x int, y int, z int, s int, image blob, PRIMARY KEY (x,y,z,s))";
    private static final String INDEX_DDL = "CREATE INDEX IF NOT EXISTS IND on tiles (x,y,z,s)";
    private static final String INSERT_SQL = "INSERT or REPLACE INTO tiles (x,y,z,s,image) VALUES (?,?,?,0,?)";
    private static final String RMAPS_TABLE_INFO_DDL = "CREATE TABLE IF NOT EXISTS info AS SELECT 99 AS minzoom, 0 AS maxzoom";
    private static final String RMAPS_CLEAR_INFO_SQL = "DELETE FROM info;";
    private static final String RMAPS_UPDATE_INFO_MINMAX_SQL = "INSERT INTO info (minzoom,maxzoom) VALUES (?,?);";
    private static final String RMAPS_INFO_MAX_SQL = "SELECT DISTINCT z FROM tiles ORDER BY z DESC LIMIT 1;";
    private static final String RMAPS_INFO_MIN_SQL = "SELECT DISTINCT z FROM tiles ORDER BY z ASC LIMIT 1;";

    @Override
    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        boolean correctTileSize = 256 == mapSpace.getTileSize();
        MapSpace.ProjectionCategory pc = mapSpace.getProjectionCategory();
        boolean correctProjection = MapSpace.ProjectionCategory.SPHERE.equals((Object)pc) || MapSpace.ProjectionCategory.ELLIPSOID.equals((Object)pc);
        return correctTileSize && correctProjection;
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, AtlasTestException, InterruptedException {
        if (customAtlasDir == null) {
            customAtlasDir = Settings.getInstance().getAtlasOutputDirectory();
        }
        super.startAtlasCreation(atlas, customAtlasDir);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.atlasDir);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        try {
            this.openConnection();
            this.initializeDB();
            this.createTiles();
        }
        catch (SQLException e) {
            throw new MapCreationException("Error creating SQL database \"" + this.databaseFile + "\": " + e.getMessage(), this.map, e);
        }
    }

    protected void initializeDB() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.executeUpdate(TABLE_DDL);
        stat.executeUpdate(INDEX_DDL);
        this.createInfoTable(stat);
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)");
        if (!stat.executeQuery("SELECT * FROM android_metadata").next()) {
            String locale = Locale.getDefault().toString();
            stat.executeUpdate("INSERT INTO android_metadata VALUES ('" + locale + "')");
        }
        stat.close();
    }

    protected void createInfoTable(Statement stat) throws SQLException {
        stat.executeUpdate(RMAPS_TABLE_INFO_DDL);
    }

    @Override
    protected void updateTileMetaInfo() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery(RMAPS_INFO_MAX_SQL);
        if (!rs.next()) {
            throw new SQLException("failed to retrieve max tile zoom info");
        }
        int max = rs.getInt(1);
        rs.close();
        rs = stat.executeQuery(RMAPS_INFO_MIN_SQL);
        if (!rs.next()) {
            throw new SQLException("failed to retrieve min tile zoom info");
        }
        int min = rs.getInt(1);
        rs.close();
        PreparedStatement ps = this.conn.prepareStatement(RMAPS_UPDATE_INFO_MINMAX_SQL);
        ps.setInt(1, min);
        ps.setInt(2, max);
        stat.execute(RMAPS_CLEAR_INFO_SQL);
        ps.execute();
        stat.close();
        ps.close();
    }

    @Override
    protected void writeTile(int x, int y, int z, byte[] tileData) throws SQLException, IOException {
        this.prepStmt.setInt(1, x);
        this.prepStmt.setInt(2, y);
        this.prepStmt.setInt(3, 17 - z);
        this.prepStmt.setBytes(4, tileData);
        this.prepStmt.addBatch();
    }

    @Override
    protected String getDatabaseFileName() {
        return this.atlas.getName() + ".sqlitedb";
    }

    @Override
    protected String getTileInsertSQL() {
        return INSERT_SQL;
    }
}

