/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.rungps.RunGPSAtlasFile;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageType;

@AtlasCreatorName(value="Run.GPS Atlas", type="RunGPS")
public class RunGPSAtlas
extends AtlasCreator {
    protected RunGPSAtlasFile atlasIndex = null;
    protected Set<String> availableTileList = new HashSet<String>();
    protected int minZoom;
    protected int maxZoom;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas, customAtlasDir);
        String atlasName = this.atlas.getName().replace(' ', '_');
        this.atlasIndex = new RunGPSAtlasFile(this.atlasDir.getPath() + File.separatorChar + atlasName + ".ratlas", true);
        this.minZoom = Integer.MAX_VALUE;
        this.maxZoom = Integer.MIN_VALUE;
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        this.atlasIndex.close();
        super.abortAtlasCreation();
    }

    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        super.finishAtlasCreation();
        this.atlasIndex.setValue("/0/0/0", 3L);
        this.atlasIndex.setString("/0/0/1", "Run.GPS Atlas File");
        this.atlasIndex.setString("/0/0/2", this.atlas.getName());
        this.atlasIndex.setString("/0/0/3", this.mapSource.getName());
        this.atlasIndex.setString("/0/0/4", "Mobile Atlas Creator");
        this.atlasIndex.setValue("/0/1/1", (long)this.minZoom);
        this.atlasIndex.setValue("/0/1/2", (long)this.maxZoom);
        this.atlasIndex.finishArchive();
        this.atlasIndex.close();
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        if (this.mapSource.getTileImageType() != TileImageType.PNG) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, TileImageFormat.PNG);
        }
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        String mapName = this.map.getMapSource().getName().replaceAll(" ", "_");
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    this.writeTile(mapName, sourceTileData, x, y, this.zoom);
                    continue;
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }

    protected boolean writeTile(String cache, byte[] tileData, int x, int y, int zoom) throws IOException {
        String cacheKey;
        if (zoom < this.minZoom) {
            this.minZoom = zoom;
        }
        if (zoom > this.maxZoom) {
            this.maxZoom = zoom;
        }
        if (this.availableTileList.contains(cacheKey = cache + "-" + zoom + "-" + x + "-" + y)) {
            this.log.warn("Map tile already in cache: " + cacheKey + " -> ignoring");
            return false;
        }
        ArrayList<Integer> hierarchy = new ArrayList<Integer>();
        hierarchy.add(zoom);
        hierarchy.add(x);
        hierarchy.add(y);
        this.atlasIndex.addData(hierarchy, tileData);
        return true;
    }
}

