/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Sports Tracker", type="NST")
@SupportedParameters(names={TileImageParameters.Name.format})
public class SportsTracker
extends AtlasCreator {
    protected File mapDir = null;
    protected MapTileWriter mapTileWriter = null;
    protected String tileType = null;
    protected static final char[] NUM_CHAR = new char[]{'q', 'r', 't', 's'};

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.mapDir = new File(this.atlasDir, layer.getName());
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.tileType = map.getMapSource().getTileImageType().getFileExt();
        TileImageParameters param = map.getParameters();
        if (param != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, param.getFormat());
            this.tileType = param.getFormat().getFileExt();
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    this.writeTile(x, y, sourceTileData);
                    continue;
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }

    public void writeTile(int tilex, int tiley, byte[] tileData) throws IOException {
        int dirCount;
        String tileName = SportsTracker.getTileName(this.zoom, tilex, tiley);
        int count = tileName.length();
        if (count % 3 == 0 & (dirCount = count / 3) > 0) {
            --dirCount;
        }
        File tileDir = this.mapDir;
        for (int i = 0; i < dirCount; ++i) {
            int start = i * 3;
            String dirName = tileName.substring(start, start + 3);
            tileDir = new File(tileDir, dirName);
        }
        String fileName = tileName + ".jpg";
        File file = new File(tileDir, fileName);
        this.writeTile(file, tileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTile(File file, byte[] tileData) throws IOException {
        Utilities.mkDirs(file.getParentFile());
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(tileData);
        }
        finally {
            Utilities.closeStream(out);
        }
    }

    public static String getTileName(int zoom, int tilex, int tiley) {
        char[] tileNum = new char[zoom + 1];
        tileNum[0] = 116;
        for (int i = zoom; i > 0; --i) {
            int num = tilex % 2 | tiley % 2 << 1;
            tileNum[i] = NUM_CHAR[num];
            tilex >>= 1;
            tiley >>= 1;
        }
        return new String(tileNum);
    }
}

