/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.Locale;
import mobac.exceptions.MapCreationException;
import mobac.program.ProgramInfo;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.Ozi;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Touratech QV", type="Ttqv")
public class TTQV
extends Ozi {
    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.layerDir);
        }
        catch (IOException e1) {
            throw new MapCreationException(this.map, (Throwable)e1);
        }
        this.createTiles();
        this.writeCalFile();
    }

    private void writeCalFile() throws MapCreationException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, this.mapName + "_png.cal"));
            OutputStreamWriter mapWriter = new OutputStreamWriter((OutputStream)fout, TEXT_FILE_CHARSET);
            MapSpace mapSpace = this.mapSource.getMapSpace();
            double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
            double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize, this.zoom);
            double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize, this.zoom);
            double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
            int width = (this.xMax - this.xMin + 1) * this.tileSize;
            int height = (this.yMax - this.yMin + 1) * this.tileSize;
            double scale = (latitudeMax - latitudeMin) * (longitudeMax - longitudeMin) / (double)(width * height);
            String nsowLine = "%s = 6 = %2.6f\r\n";
            String cLine = "c%d_%s = 7 =  %2.6f\r\n";
            mapWriter.write("; Calibration File for QV Map\r\n");
            mapWriter.write("; generated by " + ProgramInfo.getCompleteTitle() + "\r\n");
            mapWriter.write("name = 10 = " + this.mapName + ".png\r\n");
            mapWriter.write("fname = 10 = " + this.mapName + ".png\r\n");
            mapWriter.write(String.format(Locale.ENGLISH, nsowLine, "nord", latitudeMax));
            mapWriter.write(String.format(Locale.ENGLISH, nsowLine, "sued", latitudeMin));
            mapWriter.write(String.format(Locale.ENGLISH, nsowLine, "ost", longitudeMax));
            mapWriter.write(String.format(Locale.ENGLISH, nsowLine, "west", longitudeMin));
            DecimalFormat nf = new DecimalFormat("0.000000E000", Utilities.DFS_ENG);
            mapWriter.write("scale_area = 6 =  " + nf.format(scale).toLowerCase() + "\r\n");
            mapWriter.write("proj_mode = 10 = proj\r\n");
            mapWriter.write("projparams = 10 = proj=merc\r\n");
            mapWriter.write("datum1 = 10 = WGS 84# 6378137# 298.257223563# 0# 0# 0#\r\n");
            mapWriter.write("c1_x = 7 =  0\r\n");
            mapWriter.write("c1_y = 7 =  0\r\n");
            mapWriter.write("c2_x = 7 =  " + (width - 1) + "\r\n");
            mapWriter.write("c2_y = 7 =  0\r\n");
            mapWriter.write("c3_x = 7 =  " + (width - 1) + "\r\n");
            mapWriter.write("c3_y = 7 =  " + (height - 1) + "\r\n");
            mapWriter.write("c4_x = 7 =  0\r\n");
            mapWriter.write("c4_y = 7 =  " + (height - 1) + "\r\n");
            mapWriter.write("c5_x = 7 =  0\r\n");
            mapWriter.write("c5_y = 7 =  0\r\n");
            mapWriter.write("c6_x = 7 =  0\r\n");
            mapWriter.write("c6_y = 7 =  0\r\n");
            mapWriter.write("c7_x = 7 =  0\r\n");
            mapWriter.write("c7_y = 7 =  0\r\n");
            mapWriter.write("c8_x = 7 =  0\r\n");
            mapWriter.write("c8_y = 7 =  0\r\n");
            mapWriter.write("c9_x = 7 =  0\r\n");
            mapWriter.write("c9_y = 7 =  0\r\n");
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 1, "lat", latitudeMax));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 1, "lon", longitudeMin));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 2, "lat", latitudeMax));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 2, "lon", longitudeMax));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 3, "lat", latitudeMin));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 3, "lon", longitudeMax));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 4, "lat", latitudeMin));
            mapWriter.write(String.format(Locale.ENGLISH, cLine, 4, "lon", longitudeMin));
            mapWriter.flush();
            mapWriter.close();
        }
        catch (IOException e) {
            try {
                throw new MapCreationException("Error writing cal file: " + e.getMessage(), this.map, e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fout);
                throw throwable;
            }
        }
        Utilities.closeStream(fout);
    }
}

