/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import mobac.exceptions.AtlasTestException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.TrekBuddy;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarArchive;
import mobac.utilities.tar.TarTmiArchive;

@AtlasCreatorName(value="TrekBuddy tared atlas", type="TaredAtlas")
public class TrekBuddyTared
extends TrekBuddy {
    @Override
    protected void testAtlas() throws AtlasTestException {
        super.testAtlas();
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                String mapFileName = layer.getName() + "/" + map.getName() + "/" + map.getName() + ".map";
                if (mapFileName.length() <= 100) continue;
                throw new AtlasTestException("Layer and map name too long for Trekbuddy Tar format!\n" + mapFileName + "\n\nCurrent length: " + mapFileName.length() + " characters\nMaximum length: 100 characters", map);
            }
        }
    }

    @Override
    public void finishAtlasCreation() {
        this.createAtlasTarArchive("cr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAtlasTarArchive(String name) {
        this.log.trace("Creating cr.tar for atlas in dir \"" + this.atlasDir.getPath() + "\"");
        File[] atlasLayerDirs = Utilities.listSubDirectories(this.atlasDir);
        LinkedList<File> atlasMapDirs = new LinkedList<File>();
        for (File dir2 : atlasLayerDirs) {
            Utilities.addSubDirectories(atlasMapDirs, dir2, 0);
        }
        File crFile = new File(this.atlasDir, name + ".tar");
        try (TarArchive ta = null;){
            ta = new TarArchive(crFile, this.atlasDir);
            ta.writeFileFromData(name + ".tba", "Atlas 1.0\r\n".getBytes());
            for (File mapDir : atlasMapDirs) {
                ta.writeFile(mapDir);
                File mapFile = new File(mapDir, mapDir.getName() + ".map");
                ta.writeFile(mapFile);
                try {
                    mapFile.delete();
                }
                catch (Exception exception) {}
            }
            ta.writeEndofArchive();
        }
    }

    @Override
    protected MapTileWriter createMapTileWriter() throws IOException {
        return new TarTileWriter();
    }

    private class TarTileWriter
    implements MapTileWriter {
        TarArchive ta = null;
        int tileHeight = 256;
        int tileWidth = 256;

        public TarTileWriter() {
            if (TrekBuddyTared.this.parameters != null) {
                this.tileHeight = TrekBuddyTared.this.parameters.getHeight();
                this.tileWidth = TrekBuddyTared.this.parameters.getWidth();
            }
            File mapTarFile = new File(TrekBuddyTared.this.mapDir, TrekBuddyTared.this.map.getName() + ".tar");
            TrekBuddyTared.this.log.debug("Writing tiles to tared map: " + mapTarFile);
            try {
                this.ta = new TarTmiArchive(mapTarFile, null);
                ByteArrayOutputStream buf = new ByteArrayOutputStream(8192);
                TrekBuddyTared.this.writeMapFile(buf);
                this.ta.writeFileFromData(TrekBuddyTared.this.map.getName() + ".map", buf.toByteArray());
            }
            catch (IOException e) {
                TrekBuddyTared.this.log.error("", e);
            }
        }

        @Override
        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format("t_%d_%d.%s", tilex * this.tileWidth, tiley * this.tileHeight, imageFormat);
            this.ta.writeFileFromData("set/" + tileFileName, tileData);
        }

        @Override
        public void finalizeMap() {
            try {
                this.ta.writeEndofArchive();
            }
            catch (IOException e) {
                TrekBuddyTared.this.log.error("", e);
            }
            this.ta.close();
        }
    }
}

