/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.Ozi;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Ublox")
public class Ublox
extends Ozi {
    @Override
    protected void writeMapFile() {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, this.mapName + ".mcf"));
            this.writeMapFile(this.map.getName(), fout);
            Utilities.closeStream(fout);
        }
        catch (Exception e) {
            this.log.error("", e);
        }
        finally {
            Utilities.closeStream(fout);
        }
    }

    @Override
    protected void writeMapFile(String imageFileName, OutputStream stream) throws IOException {
        this.log.trace("Writing mcf file");
        OutputStreamWriter mcfWriter = new OutputStreamWriter(stream, TEXT_FILE_CHARSET);
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
        double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        String refFmt = "%d = %5d, %5d, %10.6f, %10.6f\r\n";
        mcfWriter.write("; I N F O\r\n");
        mcfWriter.write("; ------------------------------------------------------------\r\n");
        mcfWriter.write("; File: " + imageFileName + ".mcf\r\n");
        mcfWriter.write("; Source: " + this.map.getMapSource().getName() + "\r\n");
        mcfWriter.write("\r\n");
        mcfWriter.write("; R E F E R E N C E\r\n");
        mcfWriter.write("; ------------------------------------------------------------\r\n");
        mcfWriter.write("; 3 Points must be defined to calibrate a Map\r\n");
        mcfWriter.write("; Parameters:\r\n");
        mcfWriter.write("; # = index of the point (1 to 3)\r\n");
        mcfWriter.write("; x,y = image coordinates\r\n");
        mcfWriter.write("; lat,lon = world coordinates\r\n");
        mcfWriter.write("; Syntax:\r\n");
        mcfWriter.write("; # = <x>, <y>, <lon>, <lat>\r\n");
        mcfWriter.write("\r\n");
        mcfWriter.write("[REFERENCE]\r\n");
        mcfWriter.write(String.format(Locale.ENGLISH, refFmt, 1, 0, 0, longitudeMin, latitudeMax));
        mcfWriter.write(String.format(Locale.ENGLISH, refFmt, 2, width, height, longitudeMax, latitudeMin));
        mcfWriter.write(String.format(Locale.ENGLISH, refFmt, 3, width, 0, longitudeMax, latitudeMax));
        mcfWriter.flush();
    }
}

