/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import mobac.exceptions.AtlasTestException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.OSMTracker;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.PngTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.TileImageParameters;
import mobac.program.model.TileImageType;

@AtlasCreatorName(value="Viewranger")
@SupportedParameters(names={TileImageParameters.Name.format_png})
public class Viewranger
extends OSMTracker {
    public Viewranger() {
        this.tileFileNamePattern = "%d/%d/%d";
    }

    @Override
    protected void testAtlas() throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                if (map.getParameters() == null) continue;
                if (!TileImageType.PNG.equals((Object)map.getParameters().getFormat().getType())) {
                    throw new AtlasTestException("Only PNG output format allowed for Viewranger", map);
                }
                if (map.getZoom() > 18) {
                    throw new AtlasTestException("Unsupported zoom level: " + map.getZoom() + "\nMaximum supported zoom level is 18", map);
                }
                if (map.getZoom() >= 3) continue;
                throw new AtlasTestException("Unsupported zoom level: " + map.getZoom() + "\nMinimum suupported toom level is 3", map);
            }
        }
    }

    @Override
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.mapDir = new File(this.atlasDir, map.getLayer().getName());
        this.tileType = "";
        this.mapDlTileProvider = this.parameters == null ? new PngTileProvider(this.mapDlTileProvider) : new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
    }
}

