/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageParameters;
import mobac.utilities.MyMath;
import org.apache.log4j.Logger;

public class MapTileBuilder {
    private static final Logger log = Logger.getLogger(MapTileBuilder.class);
    private final AtlasCreator atlasCreator;
    private final TileProvider mapDlTileProvider;
    private final MapInterface map;
    private final MapSource mapSource;
    private final TileImageParameters parameters;
    private final TileImageDataWriter tileImageDataWriter;
    private final int tileSize;
    private final int xMin;
    private final int xMax;
    private final int yMin;
    private final int yMax;
    private final boolean useRealTileSize;
    private int realWidth;
    private int realHeight;
    int mergedWidth;
    int mergedHeight;
    final int customTileCount;
    final int xStart;
    final int yStart;
    final int xEnd;
    final int yEnd;
    protected final MapTileWriter mapTileWriter;
    private CachedTile[] cache = new CachedTile[10];
    private int cachePos = 0;

    public MapTileBuilder(AtlasCreator atlasCreator, MapTileWriter mapTileWriter, boolean useRealTileSize) {
        this(atlasCreator, atlasCreator.getParameters().getFormat().getDataWriter(), mapTileWriter, useRealTileSize);
    }

    public MapTileBuilder(AtlasCreator atlasCreator, TileImageDataWriter tileImageDataWriter, MapTileWriter mapTileWriter, boolean useRealTileSize) {
        this.atlasCreator = atlasCreator;
        this.tileImageDataWriter = tileImageDataWriter;
        this.mapTileWriter = mapTileWriter;
        this.mapDlTileProvider = atlasCreator.getMapDlTileProvider();
        this.useRealTileSize = useRealTileSize;
        this.map = atlasCreator.getMap();
        this.mapSource = this.map.getMapSource();
        this.tileSize = this.mapSource.getMapSpace().getTileSize();
        this.xMax = atlasCreator.getXMax();
        this.xMin = atlasCreator.getXMin();
        this.yMax = atlasCreator.getYMax();
        this.yMin = atlasCreator.getYMin();
        this.parameters = atlasCreator.getParameters();
        this.xStart = this.xMin * this.tileSize;
        this.yStart = this.yMin * this.tileSize;
        this.xEnd = this.xMax * this.tileSize + (this.tileSize - 1);
        this.yEnd = this.yMax * this.tileSize + (this.tileSize - 1);
        this.mergedWidth = this.xEnd - this.xStart + 1;
        this.mergedHeight = this.yEnd - this.yStart + 1;
        this.realWidth = this.parameters.getWidth();
        this.realHeight = this.parameters.getHeight();
        if (useRealTileSize) {
            if (this.realWidth > this.mergedWidth) {
                this.realWidth = this.mergedWidth;
            }
            if (this.realHeight > this.mergedHeight) {
                this.realHeight = this.mergedHeight;
            }
        }
        this.customTileCount = MyMath.divCeil(this.mergedWidth, this.realWidth) * MyMath.divCeil(this.mergedHeight, this.realHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTiles() throws MapCreationException, InterruptedException {
        int xAbsPos = this.xStart;
        log.trace("tile size: " + this.realWidth + " * " + this.realHeight);
        log.trace("X: from " + this.xStart + " to " + this.xEnd);
        log.trace("Y: from " + this.yStart + " to " + this.yEnd);
        ImageIO.setUseCache(false);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32768);
        this.tileImageDataWriter.initialize();
        int currentTileHeight = this.realHeight;
        int currentTileWidth = this.realWidth;
        try {
            String tileType = this.tileImageDataWriter.getType().getFileExt();
            int tiley = 0;
            for (int yAbsPos = this.yStart; yAbsPos < this.yEnd; yAbsPos += this.realHeight) {
                int tilex = 0;
                xAbsPos = this.xStart;
                if (this.useRealTileSize) {
                    currentTileHeight = Math.min(this.realHeight, this.yEnd - yAbsPos + 1);
                }
                while (xAbsPos < this.xEnd) {
                    if (this.useRealTileSize) {
                        currentTileWidth = Math.min(this.realWidth, this.xEnd - xAbsPos + 1);
                    }
                    this.atlasCreator.checkUserAbort();
                    this.atlasCreator.getAtlasProgress().incMapCreationProgress();
                    BufferedImage tileImage = new BufferedImage(currentTileWidth, currentTileHeight, 5);
                    buf.reset();
                    try {
                        Graphics2D graphics = tileImage.createGraphics();
                        this.prepareTile(graphics);
                        this.paintCustomTile(graphics, xAbsPos, yAbsPos);
                        graphics.dispose();
                        this.tileImageDataWriter.processImage(tileImage, buf);
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, buf.toByteArray());
                    }
                    catch (IOException e) {
                        throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                    }
                    ++tilex;
                    xAbsPos += this.realWidth;
                }
                ++tiley;
            }
        }
        finally {
            this.tileImageDataWriter.dispose();
        }
    }

    protected void prepareTile(Graphics2D graphics) {
        graphics.setColor(this.mapSource.getBackgroundColor());
        graphics.fillRect(0, 0, this.realWidth, this.realHeight);
    }

    private void paintCustomTile(Graphics2D graphics, int xAbsPos, int yAbsPos) {
        int xTileOffset;
        int xTile = xAbsPos / this.tileSize;
        for (int x = xTileOffset = -(xAbsPos % this.tileSize); x < this.realWidth; x += this.tileSize) {
            int yTileOffset;
            int yTile = yAbsPos / this.tileSize;
            for (int y = yTileOffset = -(yAbsPos % this.tileSize); y < this.realHeight; y += this.tileSize) {
                try {
                    BufferedImage orgTileImage = this.loadOriginalMapTile(xTile, yTile);
                    if (orgTileImage != null) {
                        graphics.drawImage(orgTileImage, xTileOffset, yTileOffset, this.tileSize, this.tileSize, null);
                    }
                }
                catch (Exception e) {
                    log.error("Error while painting sub-tile", e);
                }
                ++yTile;
                yTileOffset += this.tileSize;
            }
            ++xTile;
            xTileOffset += this.tileSize;
        }
    }

    public int getCustomTileCount() {
        return this.customTileCount;
    }

    private BufferedImage loadOriginalMapTile(int xTile, int yTile) throws Exception {
        for (CachedTile ct : this.cache) {
            if (ct == null || ct.xTile != xTile || ct.yTile != yTile) continue;
            return ct.image;
        }
        BufferedImage image = this.mapDlTileProvider.getTileImage(xTile, yTile);
        if (image == null) {
            return null;
        }
        this.cache[this.cachePos] = new CachedTile(image, xTile, yTile);
        this.cachePos = (this.cachePos + 1) % this.cache.length;
        return image;
    }

    private static class CachedTile {
        BufferedImage image;
        int xTile;
        int yTile;

        public CachedTile(BufferedImage image, int tile, int tile2) {
            this.image = image;
            this.xTile = tile;
            this.yTile = tile2;
        }
    }
}

