/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.aqm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import mobac.utilities.Utilities;

public class FlatPackCreator {
    public static final String FLAT_PACK_HEADER = "FLATPACK1";
    public static final int FILE_COPY_BUFFER_LEN = 40960;
    private String packPath = null;
    private FileOutputStream dataStream = null;
    private ByteArrayOutputStream structBuffer = null;
    private OutputStreamWriter structBufferWriter = null;
    private long currentDataWritedSize = 0L;
    private long currentNbFiles = 0L;

    public FlatPackCreator(File packPath) throws FileNotFoundException {
        this(packPath.getAbsolutePath());
    }

    public FlatPackCreator(String packPath) throws FileNotFoundException {
        this.packPath = packPath;
        if (packPath == null) {
            throw new NullPointerException("Pack file path is null.");
        }
        this.dataStream = new FileOutputStream(packPath + ".tmp");
        this.structBuffer = new ByteArrayOutputStream();
        this.structBufferWriter = new OutputStreamWriter((OutputStream)this.structBuffer, StandardCharsets.ISO_8859_1);
        this.currentDataWritedSize = 0L;
        this.currentNbFiles = 0L;
    }

    public final void add(String filePath, String fileEntryName) throws IOException {
        this.add(new File(filePath), fileEntryName);
    }

    public final void add(File filePath) throws IOException {
        this.add(filePath, filePath.getName());
    }

    public final void add(File filePath, String fileEntryName) throws IOException {
        FileInputStream in = new FileInputStream(filePath);
        byte[] buff = new byte[(int)filePath.length()];
        int read = in.read(buff);
        in.close();
        if (filePath.length() != (long)read) {
            throw new IOException("Error reading '" + filePath + "'.");
        }
        this.add(buff, fileEntryName);
    }

    public final void add(byte[] buff, String fileEntryName) throws IOException {
        if (this.dataStream == null) {
            throw new IOException("Write stream is null.");
        }
        String fileSize = Integer.toString(buff.length) + "\u0000";
        this.dataStream.write(fileSize.getBytes(StandardCharsets.ISO_8859_1));
        if (buff.length > 0) {
            this.dataStream.write(buff);
        }
        this.structBufferWriter.append(fileEntryName + "\u0000" + this.currentDataWritedSize + "\u0000");
        this.currentDataWritedSize += (long)(buff.length + fileSize.length());
        ++this.currentNbFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        if (this.dataStream == null) {
            throw new NullPointerException("Write stream is null.");
        }
        this.dataStream.flush();
        this.dataStream.close();
        this.dataStream = null;
        File tmpFile = new File(this.packPath + ".tmp");
        FileOutputStream packStream = new FileOutputStream(this.packPath);
        try {
            String nbFiles = Long.toString(this.currentNbFiles) + "\u0000";
            packStream.write(FLAT_PACK_HEADER.getBytes(StandardCharsets.ISO_8859_1));
            this.structBufferWriter.flush();
            this.structBufferWriter.close();
            int headerSize = this.structBuffer.size() + nbFiles.length();
            packStream.write(Integer.toString(headerSize).getBytes(StandardCharsets.ISO_8859_1));
            packStream.write(0);
            packStream.write(nbFiles.getBytes(StandardCharsets.ISO_8859_1));
            this.structBuffer.writeTo(packStream);
            this.structBufferWriter = null;
            this.structBuffer = null;
            FileInputStream in = new FileInputStream(tmpFile);
            try {
                int read;
                byte[] buffer = new byte[40960];
                while ((read = in.read(buffer)) > 0) {
                    packStream.write(buffer, 0, read);
                }
                packStream.flush();
                packStream.close();
            }
            finally {
                Utilities.closeStream(in);
            }
        }
        finally {
            Utilities.closeStream(packStream);
        }
        if (tmpFile.isFile()) {
            Utilities.deleteFile(tmpFile);
        }
        this.packPath = null;
        this.structBuffer = null;
    }
}

