/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.gemf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class GEMFFileCreator {
    private static final long FILE_SIZE_LIMIT = 0x40000000L;
    private static final int FILE_COPY_BUFFER_SIZE = 1024;
    private static final int VERSION = 4;
    private static final int TILE_SIZE = 256;
    private static final int U32_SIZE = 4;
    private static final int U64_SIZE = 8;

    public GEMFFileCreator(String pLocation, List<File> pSourceFolders, Logger log) throws FileNotFoundException, IOException {
        TreeSet yList;
        LinkedHashMap dirIndex = new LinkedHashMap();
        for (File sourceDir : pSourceFolders) {
            LinkedHashMap zList = new LinkedHashMap();
            for (File file : sourceDir.listFiles()) {
                try {
                    Integer.parseInt(file.getName());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                LinkedHashMap xList = new LinkedHashMap();
                for (File xDir : file.listFiles()) {
                    try {
                        Integer.parseInt(xDir.getName());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    yList = new LinkedHashMap<Integer, File>();
                    for (File yFile : xDir.listFiles()) {
                        try {
                            Integer.parseInt(yFile.getName().substring(0, yFile.getName().indexOf(46)));
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        ((HashMap)((Object)yList)).put(Integer.parseInt(yFile.getName().substring(0, yFile.getName().indexOf(46))), yFile);
                    }
                    xList.put(new Integer(xDir.getName()), yList);
                }
                zList.put(Integer.parseInt(file.getName()), xList);
            }
            dirIndex.put(sourceDir.getName(), zList);
        }
        LinkedHashMap<String, Integer> sourceIndex = new LinkedHashMap<String, Integer>();
        LinkedHashMap<Integer, String> indexSource = new LinkedHashMap<Integer, String>();
        int si = 0;
        for (String source : dirIndex.keySet()) {
            sourceIndex.put(source, new Integer(si));
            indexSource.put(new Integer(si), source);
            ++si;
        }
        ArrayList<GEMFRange> ranges = new ArrayList<GEMFRange>();
        for (String source : dirIndex.keySet()) {
            for (Object zoom : ((LinkedHashMap)dirIndex.get(source)).keySet()) {
                Iterator x22;
                LinkedHashMap ySets = new LinkedHashMap();
                for (Iterator x22 : new TreeSet(((LinkedHashMap)((LinkedHashMap)dirIndex.get(source)).get(zoom)).keySet())) {
                    List<Integer> ySet = new ArrayList();
                    for (Integer y : ((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(source)).get(zoom)).get(x22)).keySet()) {
                        ySet.add(y);
                    }
                    if (ySet.size() == 0) continue;
                    Collections.sort(ySet);
                    if (!ySets.containsKey(ySet)) {
                        ySets.put(ySet, new ArrayList());
                    }
                    ((List)ySets.get(ySet)).add(x22);
                }
                LinkedHashMap xSets = new LinkedHashMap();
                for (List<Integer> ySet : ySets.keySet()) {
                    TreeSet xList = new TreeSet((Collection)ySets.get(ySet));
                    ArrayList<Integer> xSet = new ArrayList<Integer>();
                    for (int i = ((Integer)xList.first()).intValue(); i < (Integer)xList.last() + 1; ++i) {
                        if (xList.contains(new Integer(i))) {
                            xSet.add(new Integer(i));
                            continue;
                        }
                        if (xSet.size() <= 0) continue;
                        xSets.put(ySet, xSet);
                        xSet = new ArrayList();
                    }
                    if (xSet.size() <= 0) continue;
                    xSets.put(ySet, xSet);
                }
                x22 = xSets.keySet().iterator();
                while (x22.hasNext()) {
                    List xSet = (List)x22.next();
                    yList = new TreeSet(xSet);
                    TreeSet xList = new TreeSet((Collection)ySets.get(xSet));
                    GEMFRange range = new GEMFRange();
                    range.zoom = zoom;
                    range.sourceIndex = (Integer)sourceIndex.get(source);
                    range.xMin = (Integer)xList.first();
                    range.xMax = (Integer)xList.last();
                    for (int i = ((Integer)yList.first()).intValue(); i < (Integer)yList.last() + 1; ++i) {
                        if (yList.contains(new Integer(i))) {
                            if (range.yMin == null) {
                                range.yMin = i;
                            }
                            range.yMax = i;
                            continue;
                        }
                        if (range.yMin == null) continue;
                        ranges.add(range);
                        range = new GEMFRange();
                        range.zoom = zoom;
                        range.sourceIndex = (Integer)sourceIndex.get(source);
                        range.xMin = (Integer)xList.first();
                        range.xMax = (Integer)xList.last();
                    }
                    if (range.yMin == null) continue;
                    ranges.add(range);
                }
            }
        }
        int source_list_size = 0;
        for (String string : sourceIndex.keySet()) {
            source_list_size += 8 + string.length();
        }
        long offset = 12 + source_list_size + ranges.size() * 32 + 4;
        for (GEMFRange range : ranges) {
            range.offset = offset;
            for (int x = range.xMin.intValue(); x < range.xMax + 1; ++x) {
                for (int y = range.yMin.intValue(); y < range.yMax + 1; ++y) {
                    offset += 12L;
                }
            }
        }
        long headerSize = offset;
        RandomAccessFile gemfFile = new RandomAccessFile(pLocation, "rw");
        gemfFile.writeInt(4);
        gemfFile.writeInt(256);
        gemfFile.writeInt(sourceIndex.size());
        for (String source : sourceIndex.keySet()) {
            gemfFile.writeInt((Integer)sourceIndex.get(source));
            gemfFile.writeInt(source.length());
            gemfFile.write(source.getBytes());
        }
        gemfFile.writeInt(ranges.size());
        for (GEMFRange range : ranges) {
            gemfFile.writeInt(range.zoom);
            gemfFile.writeInt(range.xMin);
            gemfFile.writeInt(range.xMax);
            gemfFile.writeInt(range.yMin);
            gemfFile.writeInt(range.yMax);
            gemfFile.writeInt(range.sourceIndex);
            gemfFile.writeLong(range.offset);
        }
        for (GEMFRange range : ranges) {
            for (int x = range.xMin.intValue(); x < range.xMax + 1; ++x) {
                for (int y = range.yMin.intValue(); y < range.yMax + 1; ++y) {
                    gemfFile.writeLong(offset);
                    long fileSize = 0L;
                    try {
                        fileSize = ((File)((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(indexSource.get(range.sourceIndex))).get(range.zoom)).get(x)).get(y)).length();
                    }
                    catch (NullPointerException yFile) {
                        // empty catch block
                    }
                    gemfFile.writeInt((int)fileSize);
                    offset += fileSize;
                }
            }
        }
        byte[] buf = new byte[1024];
        long currentOffset = headerSize;
        int fileIndex = 0;
        for (GEMFRange range : ranges) {
            for (int x = range.xMin.intValue(); x < range.xMax + 1; ++x) {
                for (int y = range.yMin.intValue(); y < range.yMax + 1; ++y) {
                    long fileSize = 0L;
                    try {
                        fileSize = ((File)((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(indexSource.get(range.sourceIndex))).get(range.zoom)).get(x)).get(y)).length();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (currentOffset + fileSize > 0x40000000L) {
                        gemfFile.close();
                        gemfFile = new RandomAccessFile(pLocation + "-" + ++fileIndex, "rw");
                        currentOffset = 0L;
                    } else {
                        currentOffset += fileSize;
                    }
                    try {
                        FileInputStream tile = new FileInputStream((File)((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(indexSource.get(range.sourceIndex))).get(range.zoom)).get(x)).get(y));
                        int read = tile.read(buf, 0, 1024);
                        while (read != -1) {
                            gemfFile.write(buf, 0, read);
                            read = tile.read(buf, 0, 1024);
                        }
                        tile.close();
                        continue;
                    }
                    catch (Exception e) {
                        log.warn("Please check that all required Tiles have been downloaded correctly. I am missing tile for x=" + x + ", y=" + y + ", z=" + range.zoom);
                    }
                }
            }
        }
        gemfFile.close();
    }

    private class GEMFRange {
        Integer zoom;
        Integer xMin;
        Integer xMax;
        Integer yMin;
        Integer yMax;
        Integer sourceIndex;
        Long offset;

        private GEMFRange() {
        }

        public String toString() {
            return String.format("GEMF Range: source=%d, zoom=%d, x=%d-%d, y=%d-%d, offset=0x%08X", this.sourceIndex, this.zoom, this.xMin, this.xMax, this.yMin, this.yMax, this.offset);
        }
    }
}

