/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import mobac.exceptions.MapCreationException;
import mobac.program.atlascreators.impl.rmp.BoundingRect;
import mobac.program.atlascreators.impl.rmp.MobacTile;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.collections.SoftHashMap;
import org.apache.log4j.Logger;

public class MultiImage {
    private static final Logger log = Logger.getLogger(MultiImage.class);
    private final MapInterface map;
    private final MapSource mapSource;
    private final int zoom;
    private final TileProvider tileProvider;
    private SoftHashMap<TileKey, MobacTile> cache;

    public MultiImage(MapSource mapSource, TileProvider tileProvider, MapInterface map) {
        this.mapSource = mapSource;
        this.tileProvider = tileProvider;
        this.zoom = map.getZoom();
        this.map = map;
        this.cache = new SoftHashMap(400);
    }

    public BufferedImage getSubImage(BoundingRect area, int width, int height) throws MapCreationException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("getSubImage %d %d %s", width, height, area));
        }
        MapSpace mapSpace = this.mapSource.getMapSpace();
        int tilesize = mapSpace.getTileSize();
        int xMax = this.mapSource.getMapSpace().cLonToX(area.getEast(), this.zoom) / tilesize;
        int xMin = this.mapSource.getMapSpace().cLonToX(area.getWest(), this.zoom) / tilesize;
        int yMax = this.mapSource.getMapSpace().cLatToY(-area.getSouth(), this.zoom) / tilesize;
        int yMin = this.mapSource.getMapSpace().cLatToY(-area.getNorth(), this.zoom) / tilesize;
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics2D graph = result.createGraphics();
        try {
            graph.setColor(Color.WHITE);
            graph.fillRect(0, 0, width, height);
            for (int x = xMin; x <= xMax; ++x) {
                for (int y = yMin; y <= yMax; ++y) {
                    TileKey key = new TileKey(x, y);
                    MobacTile image = this.cache.get(key);
                    if (image == null) {
                        image = new MobacTile(this.tileProvider, mapSpace, x, y, this.zoom);
                        this.cache.put(key, image);
                    }
                    image.drawSubImage(area, result);
                }
            }
        }
        catch (Throwable t) {
            throw new MapCreationException(this.map, t);
        }
        finally {
            graph.dispose();
        }
        return result;
    }

    protected static class TileKey {
        int x;
        int y;

        public TileKey(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TileKey other = (TileKey)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }
    }
}

