/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import mobac.gui.AtlasProgress;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.atlascreators.impl.rmp.TileContainer;
import mobac.program.atlascreators.impl.rmp.Tiledata;
import mobac.program.atlascreators.impl.rmp.interfaces.RmpFileEntry;
import org.apache.log4j.Logger;

public class RmpLayer {
    private static final Logger log = Logger.getLogger(RmpLayer.class);
    private List<Tiledata> tiles = new LinkedList<Tiledata>();
    private TLMEntry tlmFile = null;
    private final AtlasCreator atlasCreator;

    public RmpLayer(AtlasCreator atlasCreator) {
        this.atlasCreator = atlasCreator;
    }

    public RmpFileEntry getA00File(String image_name) {
        return new A00Entry(image_name);
    }

    public TLMEntry getTLMFile(String image_name) {
        this.tlmFile.setImageName(image_name);
        return this.tlmFile;
    }

    public void addPreparedImage(Tiledata tileData) throws IOException {
        this.tiles.add(tileData);
    }

    private TileContainer buildTileTree() {
        TileContainer indexContainer = null;
        int count = this.tiles.size();
        int containerCount = count / 80;
        if (count % 80 != 0) {
            ++containerCount;
        }
        int tilesPerContainer = count / containerCount;
        TileContainer[] container = new TileContainer[containerCount];
        for (int i = 0; i < containerCount; ++i) {
            container[i] = new TileContainer();
        }
        if (containerCount > 1) {
            indexContainer = new TileContainer(container[0]);
        }
        int tileCount = 0;
        int totalTileCount = 0;
        int containerNumber = 0;
        for (Tiledata tiledata : this.tiles) {
            if (tileCount == 0 && containerNumber != 0) {
                indexContainer.addTile(tiledata, container[containerNumber]);
            } else {
                container[containerNumber].addTile(tiledata, null);
            }
            if (++tileCount == tilesPerContainer) {
                tileCount = 0;
                if (containerCount != ++containerNumber) {
                    tilesPerContainer = (count - (totalTileCount + 1)) / (containerCount - containerNumber);
                }
            }
            ++totalTileCount;
        }
        if (indexContainer == null) {
            return container[0];
        }
        return indexContainer;
    }

    public void buildTLMFile(double tile_width, double tile_height, double left, double right, double top, double bottom) throws IOException {
        this.tlmFile = new TLMEntry(tile_width, tile_height, left, right, top, bottom);
        this.tlmFile.updateContent();
    }

    protected class A00Entry
    implements RmpFileEntry {
        protected String name;

        public A00Entry(String name) {
            this.name = name;
        }

        @Override
        public String getFileExtension() {
            return "a00";
        }

        @Override
        public String getFileName() {
            return this.name;
        }

        @Override
        public void writeFileContent(OutputStream os) throws IOException, InterruptedException {
            BufferedOutputStream bos = new BufferedOutputStream(os, 32768);
            RmpTools.writeValue((OutputStream)bos, RmpLayer.this.tiles.size(), 4);
            AtlasProgress atlasProgress = RmpLayer.this.atlasCreator.getAtlasProgress();
            int x = 0;
            int xMax = RmpLayer.this.tiles.size();
            for (Tiledata tile : RmpLayer.this.tiles) {
                tile.writeTileData(bos);
                RmpLayer.this.atlasCreator.checkUserAbort();
                atlasProgress.setMapCreationProgress(1000 * x++ / xMax);
            }
            bos.flush();
        }

        public String toString() {
            return "A00Entry";
        }
    }

    public class TLMEntry
    implements RmpFileEntry {
        private byte[] data = null;
        String imageName;
        final double tile_width;
        final double tile_height;
        final double left;
        final double right;
        final double top;
        final double bottom;

        public TLMEntry(double tile_width, double tile_height, double left, double right, double top, double bottom) {
            this.tile_width = tile_width;
            this.tile_height = tile_height;
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public void updateContent() throws IOException {
            int totaloffset = 4;
            for (Tiledata tile : RmpLayer.this.tiles) {
                tile.totalOffset = totaloffset;
                totaloffset += tile.getTileDataSize() + 4;
            }
            TileContainer container = RmpLayer.this.buildTileTree();
            log.debug("Number of output tiles: " + container.getTileCount());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(16384);
            RmpTools.writeValue((OutputStream)bos, 1, 4);
            RmpTools.writeValue((OutputStream)bos, container.getTileCount(), 4);
            RmpTools.writeValue((OutputStream)bos, 256, 2);
            RmpTools.writeValue((OutputStream)bos, 256, 2);
            RmpTools.writeValue((OutputStream)bos, 1, 4);
            RmpTools.writeDouble(bos, this.tile_height);
            RmpTools.writeDouble(bos, this.tile_width);
            RmpTools.writeDouble(bos, this.left);
            RmpTools.writeDouble(bos, this.top);
            RmpTools.writeDouble(bos, this.right);
            RmpTools.writeDouble(bos, this.bottom);
            RmpTools.writeValue((OutputStream)bos, 0, 88);
            RmpTools.writeValue((OutputStream)bos, 256, 2);
            RmpTools.writeValue((OutputStream)bos, 0, 2);
            int size = 8172;
            size += container.getContainerCount() * 1992;
            if (container.getContainerCount() != 1) {
                size += 1992;
            }
            RmpTools.writeValue((OutputStream)bos, size, 4);
            RmpTools.writeValue((OutputStream)bos, 0, 96);
            RmpTools.writeValue((OutputStream)bos, 1, 4);
            RmpTools.writeValue((OutputStream)bos, 99, 4);
            int firstBlockOffset = 3932 + (container.getContainerCount() == 1 ? 0 : 1992);
            RmpTools.writeValue((OutputStream)bos, firstBlockOffset, 4);
            RmpTools.writeValue((OutputStream)bos, 0, 3920);
            container.writeTree(bos);
            RmpTools.writeValue((OutputStream)bos, 0, 3984);
            this.data = bos.toByteArray();
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public String getFileExtension() {
            return "tlm";
        }

        @Override
        public String getFileName() {
            return this.imageName;
        }

        @Override
        public void writeFileContent(OutputStream out) throws IOException {
            out.write(this.data);
        }
    }
}

