/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import mobac.program.atlascreators.impl.rmp.ChecksumOutputStream;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.atlascreators.impl.rmp.interfaces.RmpFileEntry;
import mobac.program.atlascreators.impl.rmp.rmpfile.RmpIni;
import mobac.utilities.Utilities;
import mobac.utilities.stream.CountingOutputStream;
import mobac.utilities.stream.RandomAccessFileOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;

public class RmpWriter {
    public static final long MAX_FILE_SIZE = 0xFFFFFFFFL;
    private static final Logger log = Logger.getLogger(RmpWriter.class);
    private final ArrayList<EntryInfo> entries = new ArrayList();
    private final File rmpFile;
    private final RandomAccessFile rmpOutputFile;
    private int projectedEntryCount;
    private ChecksumOutputStream entryOut;

    public RmpWriter(String imageName, int layerCount, File rmpFile) throws IOException, InterruptedException {
        this.rmpFile = rmpFile;
        this.projectedEntryCount = 3 + 2 * layerCount;
        if (rmpFile.exists()) {
            Utilities.deleteFile(rmpFile);
        }
        log.debug("Writing data to " + rmpFile.getAbsolutePath());
        this.rmpOutputFile = new RandomAccessFile(rmpFile, "rw");
        int directoryEndOffset = this.projectedEntryCount * 24 + 10;
        this.rmpOutputFile.seek(directoryEndOffset);
        this.entryOut = new ChecksumOutputStream(new RandomAccessFileOutputStream(this.rmpOutputFile));
        RmpTools.writeFixedString(this.entryOut, "MAGELLAN", 30);
        RmpIni rmpIni = new RmpIni(imageName, layerCount);
        this.writeFileEntry(rmpIni);
    }

    public void writeFileEntry(RmpFileEntry entry) throws IOException, InterruptedException {
        EntryInfo info = new EntryInfo();
        info.name = entry.getFileName();
        info.extendsion = entry.getFileExtension();
        info.offset = this.rmpOutputFile.getFilePointer();
        entry.writeFileContent(this.entryOut);
        info.length = this.rmpOutputFile.getFilePointer() - info.offset;
        if (info.length % 2L != 0L) {
            this.entryOut.write(0);
        }
        this.entries.add(info);
        if (this.rmpOutputFile.getFilePointer() > 0xFFFFFFFFL) {
            this.throwRmpTooLarge();
        }
        log.debug("Written data of entry " + entry + " bytes=" + info.length);
    }

    public void prepareFileEntry(RmpFileEntry entry) throws IOException, InterruptedException {
        long pos;
        EntryInfo info = new EntryInfo();
        info.name = entry.getFileName();
        info.extendsion = entry.getFileExtension();
        info.offset = pos = this.rmpOutputFile.getFilePointer();
        CountingOutputStream cout = new CountingOutputStream(new NullOutputStream());
        entry.writeFileContent(cout);
        info.length = cout.getBytesWritten();
        long newPos = pos + info.length;
        if (info.length % 2L != 0L) {
            ++newPos;
        }
        if (newPos > 0xFFFFFFFFL) {
            this.throwRmpTooLarge();
        }
        this.rmpOutputFile.seek(newPos);
        this.entries.add(info);
        log.debug("Prepared data of entry " + entry + " bytes=" + info.length);
    }

    public void writePreparedFileEntry(RmpFileEntry entry) throws IOException, InterruptedException {
        long newLength;
        long pos = this.rmpOutputFile.getFilePointer();
        EntryInfo info = new EntryInfo();
        info.name = entry.getFileName();
        info.extendsion = entry.getFileExtension();
        int index = this.entries.indexOf(info);
        if (index < 0) {
            throw new RuntimeException("Index for entry not found");
        }
        info = this.entries.get(index);
        this.rmpOutputFile.seek(info.offset);
        entry.writeFileContent(this.entryOut);
        if (this.rmpOutputFile.getFilePointer() > 0xFFFFFFFFL) {
            this.throwRmpTooLarge();
        }
        if ((newLength = this.rmpOutputFile.getFilePointer() - info.offset) != info.length) {
            throw new RuntimeException("Length of entry has changed!");
        }
        if (newLength % 2L != 0L) {
            this.entryOut.write(0);
        }
        this.rmpOutputFile.seek(pos);
    }

    private void throwRmpTooLarge() throws IOException {
        throw new IOException("RMP file size exeeds 2GiB! The RMP file format does not support that.");
    }

    public void writeDirectory() throws IOException {
        if (this.projectedEntryCount != this.entries.size()) {
            throw new RuntimeException("Entry count does not correspond to the projected layer count: \nProjected: " + this.projectedEntryCount + "\nPresent:" + this.entries.size());
        }
        RmpTools.writeFixedString(this.entryOut, "MAGELLAN", 8);
        this.entryOut.writeChecksum();
        log.debug("Finished writing entries, updating directory");
        this.rmpOutputFile.seek(0L);
        RandomAccessFileOutputStream out = new RandomAccessFileOutputStream(this.rmpOutputFile);
        ChecksumOutputStream cout = new ChecksumOutputStream(out);
        RmpTools.writeValue((OutputStream)cout, this.entries.size(), 4);
        RmpTools.writeValue((OutputStream)cout, this.entries.size(), 4);
        log.debug("Writing directory: " + this.entries.size() + " entries");
        for (EntryInfo entryInfo : this.entries) {
            log.trace("Entry: " + entryInfo);
            RmpTools.writeFixedString(cout, entryInfo.name, 9);
            RmpTools.writeFixedString(cout, entryInfo.extendsion, 7);
            RmpTools.writeValue((OutputStream)cout, entryInfo.offset, 4);
            RmpTools.writeValue((OutputStream)cout, entryInfo.length, 4);
        }
        cout.writeChecksum();
    }

    public void close() {
        try {
            this.rmpOutputFile.close();
        }
        catch (Exception e) {
            log.error("", e);
        }
    }

    public void delete() throws IOException {
        this.close();
        Utilities.deleteFile(this.rmpFile);
    }

    private static class EntryInfo {
        String name;
        String extendsion;
        long offset;
        long length;

        private EntryInfo() {
        }

        public String toString() {
            return "\"" + this.name + "." + this.extendsion + "\" offset=" + this.offset + " length=" + this.length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.extendsion == null ? 0 : this.extendsion.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryInfo other = (EntryInfo)obj;
            if (this.extendsion == null ? other.extendsion != null : !this.extendsion.equals(other.extendsion)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

