/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rungps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import mobac.utilities.Utilities;

public class RunGPSAtlasFile {
    public static final String SUFFIX = ".ratlas";
    RandomAccessFile raf;
    RunGPSAtlasHeader rah = new RunGPSAtlasHeader();
    File cacheFile;
    OutputStream cacheOutStream = null;
    long positionInCacheFile = 0L;
    int offset = 128;
    int indexLength = 0;

    public boolean readSuccess() {
        return this.rah.readSuccess();
    }

    public RunGPSAtlasFile(String filePath, boolean write) throws IOException {
        if (write) {
            this.cacheFile = new File(filePath + ".cac");
            this.cacheOutStream = new BufferedOutputStream(new FileOutputStream(this.cacheFile), 8216);
            this.raf = new RandomAccessFile(filePath, "rw");
            this.raf.setLength(0L);
            this.indexLength = this.offset;
            RAINode root = new RAINode();
            root.writeNew();
        } else {
            this.raf = new RandomAccessFile(filePath, "r");
            this.rah.readHeader();
        }
    }

    public RAINode getRootNode() throws IOException {
        RAINode root = new RAINode();
        root.readFrom(this.offset);
        return root;
    }

    public String listAll() throws IOException {
        return this.getRootNode().listAll();
    }

    public void close() throws IOException {
        if (this.cacheOutStream != null) {
            this.cacheOutStream.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public void finishArchive() throws IOException {
        int l;
        this.cacheOutStream.close();
        this.cacheOutStream = null;
        FileInputStream fis = new FileInputStream(this.cacheFile);
        this.rah.indexSize = this.indexLength - 128;
        this.rah.writeHeader();
        byte[] buf = new byte[4096];
        this.raf.seek(this.indexLength);
        while ((l = fis.read(buf)) > 0) {
            this.raf.write(buf, 0, l);
        }
        fis.close();
        Utilities.deleteFile(this.cacheFile);
        this.close();
    }

    public void addData(List<Integer> hierarchy, byte[] data) throws IOException {
        this.addData(hierarchy, data, data.length);
    }

    public void addData(List<Integer> hierarchy, byte[] data, int length) throws IOException {
        this.cacheOutStream.write(data, 0, length);
        ArrayList<Integer> posHierarchy = new ArrayList<Integer>();
        posHierarchy.addAll(hierarchy);
        posHierarchy.add(1);
        this.setValue(posHierarchy, this.positionInCacheFile);
        ArrayList<Integer> lenHierarchy = new ArrayList<Integer>();
        lenHierarchy.addAll(hierarchy);
        lenHierarchy.add(2);
        this.setValue(lenHierarchy, (long)length);
        this.positionInCacheFile += (long)length;
    }

    public static List<Integer> makeHierarchyFromPath(String path) {
        int p = (path = path.replace(File.separatorChar, '/')).indexOf(46);
        if (p > 0) {
            path = path.substring(0, p);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            ArrayList<Integer> hierarchy = new ArrayList<Integer>();
            while ((p = path.indexOf(47)) > 0) {
                hierarchy.add(Integer.parseInt(path.substring(0, p)));
                path = path.substring(p + 1);
            }
            hierarchy.add(Integer.parseInt(path));
            return hierarchy;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public byte[] getData(String path) throws IOException {
        return this.getData(RunGPSAtlasFile.makeHierarchyFromPath(path));
    }

    public byte[] getData(List<Integer> keyHierarchy) throws IOException {
        ArrayList<Integer> posHierarchy = new ArrayList<Integer>();
        posHierarchy.addAll(keyHierarchy);
        posHierarchy.add(1);
        long indexPosition = this.getValue(posHierarchy);
        if (indexPosition == -1L) {
            return null;
        }
        ArrayList<Integer> sizeHierarchy = new ArrayList<Integer>();
        sizeHierarchy.addAll(keyHierarchy);
        sizeHierarchy.add(2);
        int size = (int)this.getValue(sizeHierarchy);
        if (size == -1) {
            return null;
        }
        byte[] buf = new byte[size];
        this.raf.seek((long)(128 + this.rah.indexSize) + indexPosition);
        this.raf.readFully(buf);
        return buf;
    }

    public void setValue(List<Integer> keyHierarchy, long value) throws IOException {
        this.setValueImpl(this.getRootNode(), keyHierarchy, value);
    }

    public void setValue(String path, long value) throws IOException {
        this.setValue(RunGPSAtlasFile.makeHierarchyFromPath(path), value);
    }

    private void setValueImpl(RAINode currentNode, List<Integer> keyHierarchy, long value) throws IOException {
        int key = keyHierarchy.get(0);
        keyHierarchy.remove(0);
        RAINode n = currentNode.getChildNode(key, true);
        if (keyHierarchy.isEmpty()) {
            n.value = value;
            n.write();
        } else {
            this.setValueImpl(n, keyHierarchy, value);
        }
    }

    public long getValue(List<Integer> keyHierarchy) throws IOException {
        RAINode n = this.getRootNode().getChildNode(keyHierarchy);
        return n == null ? -1L : n.value;
    }

    public long getValue(String path) throws IOException {
        return this.getValue(RunGPSAtlasFile.makeHierarchyFromPath(path));
    }

    public void setString(List<Integer> keyHierarchy, String value) throws IOException {
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        this.addData(keyHierarchy, data);
    }

    public void setString(String path, String value) throws IOException {
        this.setString(RunGPSAtlasFile.makeHierarchyFromPath(path), value);
    }

    public String getString(List<Integer> keyHierarchy) throws IOException {
        byte[] data = this.getData(keyHierarchy);
        if (data != null) {
            return new String(data, StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getString(String path) throws IOException {
        return this.getString(RunGPSAtlasFile.makeHierarchyFromPath(path));
    }

    public class RunGPSAtlasHeader {
        public static final long FILETYPE_KEY = 8723487877262773L;
        public static final int HEADER_SIZE = 128;
        public static final int FILE_VERSION = 3;
        int indexSize;

        public void writeHeader() throws IOException {
            RunGPSAtlasFile.this.raf.seek(0L);
            RunGPSAtlasFile.this.raf.writeLong(8723487877262773L);
            RunGPSAtlasFile.this.raf.writeInt(3);
            RunGPSAtlasFile.this.raf.writeInt(this.indexSize);
        }

        public boolean readHeader() throws IOException {
            if (RunGPSAtlasFile.this.raf.readLong() != 8723487877262773L) {
                return false;
            }
            if (RunGPSAtlasFile.this.raf.readInt() != 3) {
                return false;
            }
            this.indexSize = RunGPSAtlasFile.this.raf.readInt();
            return true;
        }

        public boolean readSuccess() {
            return this.indexSize > 0;
        }
    }

    public class RAINode {
        int key = -1;
        long value = -1L;
        int next = -1;
        int child = -1;
        int index = -1;

        RAINode() {
        }

        void readFrom(int index) throws IOException {
            this.index = index;
            RunGPSAtlasFile.this.raf.seek(index);
            this.key = RunGPSAtlasFile.this.raf.readInt();
            this.value = RunGPSAtlasFile.this.raf.readLong();
            this.next = RunGPSAtlasFile.this.raf.readInt();
            this.child = RunGPSAtlasFile.this.raf.readInt();
        }

        void writeNew() throws IOException {
            RunGPSAtlasFile.this.raf.seek(RunGPSAtlasFile.this.indexLength);
            RunGPSAtlasFile.this.raf.writeInt(this.key);
            RunGPSAtlasFile.this.raf.writeLong(this.value);
            RunGPSAtlasFile.this.raf.writeInt(this.next);
            RunGPSAtlasFile.this.raf.writeInt(this.child);
            this.index = RunGPSAtlasFile.this.indexLength;
            RunGPSAtlasFile.this.indexLength += 20;
        }

        void write() throws IOException {
            RunGPSAtlasFile.this.raf.seek(this.index + 4);
            RunGPSAtlasFile.this.raf.writeLong(this.value);
            RunGPSAtlasFile.this.raf.writeInt(this.next);
            RunGPSAtlasFile.this.raf.writeInt(this.child);
        }

        String listAll() throws IOException {
            return this.listAll("");
        }

        String listAll(String path) throws IOException {
            List<RAINode> children = this.getChildren();
            StringBuilder sb = new StringBuilder();
            if (this.key != -1) {
                path = path + "" + this.key + "/";
                if (this.value != -1L) {
                    sb.append(path).append('=').append(this.value).append("\n");
                }
            }
            for (RAINode childNode : children) {
                sb.append(childNode.listAll(path));
            }
            return sb.toString();
        }

        List<RAINode> getChildren() throws IOException {
            ArrayList<RAINode> children = new ArrayList<RAINode>();
            int indexPos = this.child;
            while (indexPos != -1) {
                RAINode n = new RAINode();
                n.readFrom(indexPos);
                children.add(n);
                indexPos = n.next;
            }
            return children;
        }

        RAINode getChildNode(int key, boolean createNew) throws IOException {
            if (this.child == -1) {
                RAINode newNode = new RAINode();
                newNode.key = key;
                newNode.writeNew();
                this.child = newNode.index;
                this.write();
                return newNode;
            }
            RAINode n = new RAINode();
            int currentIndexPos = this.child;
            while (currentIndexPos != -1) {
                n.readFrom(currentIndexPos);
                if (n.key == key) {
                    return n;
                }
                currentIndexPos = n.next;
            }
            if (!createNew) {
                return null;
            }
            RAINode newNode = new RAINode();
            newNode.key = key;
            newNode.writeNew();
            n.next = newNode.index;
            n.write();
            return newNode;
        }

        public int getSize() {
            return RunGPSAtlasFile.this.indexLength;
        }

        public RandomAccessFile getRandomAccessFile() {
            return RunGPSAtlasFile.this.raf;
        }

        RAINode getChildNode(List<Integer> hierarchy) throws IOException {
            if (hierarchy.isEmpty()) {
                return this;
            }
            int key_ = hierarchy.get(0);
            hierarchy.remove(0);
            RAINode childNode = this.getChildNode(key_, false);
            if (childNode == null) {
                return null;
            }
            return childNode.getChildNode(hierarchy);
        }
    }
}

