/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapSource;
import org.apache.log4j.Logger;

public class CacheTileProvider
implements TileProvider {
    private Logger log = Logger.getLogger(CacheTileProvider.class);
    private static int PRELOADER_THREAD_NUM = 1;
    private Hashtable<CacheKey, SRCachedTile> cache;
    private PreLoadThread preLoader = new PreLoadThread();
    protected final TileProvider tileProvider;

    public CacheTileProvider(TileProvider tileProvider) {
        this.tileProvider = tileProvider;
        this.cache = new Hashtable(500);
        this.preLoader.start();
    }

    @Override
    public boolean preferTileImageUsage() {
        return true;
    }

    @Override
    public BufferedImage getTileImage(int x, int y) throws IOException {
        CachedTile tile;
        SRCachedTile cachedTile = this.cache.get(new CacheKey(x, y));
        BufferedImage image = null;
        if (cachedTile != null && (tile = (CachedTile)cachedTile.get()) != null) {
            if (tile.loaded) {
                this.log.trace(String.format("Cache hit: x=%d y=%d", x, y));
            }
            image = tile.getImage();
            if (!tile.nextLoadJobCreated) {
                this.preloadTile(new CachedTile(new CacheKey(x + 1, y)));
                tile.nextLoadJobCreated = true;
            }
        }
        if (image == null) {
            this.log.trace(String.format("Cache miss: x=%d y=%d", x, y));
            this.preloadTile(new CachedTile(new CacheKey(x + 1, y)));
            image = this.internalGetTileImage(x, y);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage internalGetTileImage(int x, int y) throws IOException {
        TileProvider tileProvider = this.tileProvider;
        synchronized (tileProvider) {
            return this.tileProvider.getTileImage(x, y);
        }
    }

    public byte[] getTileData(int layer, int x, int y) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public byte[] getTileData(int x, int y) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public MapSource getMapSource() {
        return this.tileProvider.getMapSource();
    }

    private void preloadTile(CachedTile tile) {
        if (this.preLoader.queue.remainingCapacity() < 1) {
            this.log.trace("Preloading rejected: " + tile.key);
            return;
        }
        if (this.cache.get(tile.key) != null) {
            return;
        }
        try {
            this.preLoader.queue.add(tile);
            this.cache.put(tile.key, new SRCachedTile(tile));
        }
        catch (IllegalStateException e) {
            this.log.trace("Preloading rejected: " + tile.key);
        }
    }

    public void cleanup() {
        try {
            this.cache.clear();
            if (this.preLoader != null) {
                this.preLoader.interrupt();
                this.preLoader = null;
            }
        }
        catch (Throwable t) {
            this.log.error("", t);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    private class CachedTile {
        CacheKey key;
        private BufferedImage image;
        private IOException loadException = null;
        boolean loaded = false;
        boolean nextLoadJobCreated = false;

        public CachedTile(CacheKey key) {
            this.key = key;
            this.image = null;
        }

        public synchronized void loadImage() {
            try {
                this.image = CacheTileProvider.this.internalGetTileImage(this.key.x, this.key.y);
            }
            catch (IOException e) {
                this.loadException = e;
            }
            catch (Exception e) {
                this.loadException = new IOException(e);
            }
            this.loaded = true;
        }

        public synchronized BufferedImage getImage() throws IOException {
            if (!this.loaded) {
                this.loadImage();
            }
            if (this.loadException != null) {
                throw this.loadException;
            }
            return this.image;
        }

        public String toString() {
            return "CachedTile [key=" + this.key + ", loaded=" + this.loaded + ", nextLoadJobCreated=" + this.nextLoadJobCreated + "]";
        }
    }

    private static class CacheKey {
        int x;
        int y;

        public CacheKey(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        public String toString() {
            return "CacheKey [x=" + this.x + ", y=" + this.y + "]";
        }
    }

    private class PreLoadThread
    extends Thread {
        private LinkedBlockingQueue<CachedTile> queue;

        public PreLoadThread() {
            super("ImagePreLoadThread" + PRELOADER_THREAD_NUM++);
            this.queue = null;
            CacheTileProvider.this.log.debug("Image pre-loader thread started");
            this.queue = new LinkedBlockingQueue(20);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    CachedTile tile;
                    if ((tile = this.queue.take()) == null || tile.loaded) {
                        continue;
                    }
                    tile.loadImage();
                }
            }
            catch (InterruptedException e) {
                CacheTileProvider.this.log.debug("Image pre-loader thread terminated");
                return;
            }
        }
    }

    private static class SRCachedTile
    extends SoftReference<CachedTile> {
        public SRCachedTile(CachedTile referent) {
            super(referent);
        }
    }
}

