/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageType;
import mobac.utilities.tar.TarIndex;
import org.apache.log4j.Logger;

public class DownloadedTileProvider
implements TileProvider {
    private static final Logger log = Logger.getLogger(DownloadedTileProvider.class);
    public static final String TILE_FILENAME_PATTERN = "x%dy%d";
    protected final TarIndex tarIndex;
    protected final MapInterface map;
    protected final TileImageType mapTileType;

    public DownloadedTileProvider(TarIndex tarIndex, MapInterface map) {
        this.tarIndex = tarIndex;
        this.map = map;
        this.mapTileType = map.getMapSource().getTileImageType();
    }

    @Override
    public byte[] getTileData(int x, int y) throws IOException {
        log.trace("Reading tile x=" + x + " y=" + y);
        return this.tarIndex.getEntryContent(String.format(TILE_FILENAME_PATTERN, x, y));
    }

    @Override
    public BufferedImage getTileImage(int x, int y) throws IOException {
        byte[] unconvertedTileData = this.getTileData(x, y);
        if (unconvertedTileData == null) {
            return null;
        }
        try {
            return ImageIO.read(new ByteArrayInputStream(unconvertedTileData));
        }
        catch (Exception e) {
            throw new IOException("Unable to load image x=" + x + " y=" + y + " - error: " + e);
        }
    }

    @Override
    public boolean preferTileImageUsage() {
        return false;
    }

    @Override
    public MapSource getMapSource() {
        return this.map.getMapSource();
    }
}

