/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mobac.data.gpx.gpx11.Gpx;
import mobac.data.gpx.gpx11.TrkType;
import mobac.data.gpx.gpx11.TrksegType;
import mobac.data.gpx.gpx11.WptType;
import mobac.data.gpx.interfaces.GpxPoint;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.MapSourceProvider;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.TileImageFormat;

public class GpxPainterTileProvider
extends ConvertedRawTileProvider {
    private final MapSpace mapSpace;
    private final int zoom;
    private List<Point> points = new ArrayList<Point>();
    private List<Line> lines = new ArrayList<Line>();

    public GpxPainterTileProvider(MapSourceProvider tileProvider, TileImageFormat tileImageFormat, Gpx gpx) {
        super(tileProvider, tileImageFormat);
        this.zoom = tileProvider.getZoom();
        MapSource mapSource = tileProvider.getMapSource();
        this.mapSpace = mapSource.getMapSpace();
        for (TrkType trk : gpx.getTrk()) {
            for (TrksegType trkSeg : trk.getTrkseg()) {
                List<WptType> trackPoints = trkSeg.getTrkpt();
                if (trackPoints.size() < 2) continue;
                Point last = this.convert(trackPoints.get(0));
                this.points.add(last);
                for (int i = 1; i < trackPoints.size(); ++i) {
                    Point current = this.convert(trackPoints.get(i));
                    this.points.add(current);
                    this.lines.add(new Line(last, current));
                    last = current;
                }
            }
        }
    }

    private Point convert(GpxPoint gpxPoint) {
        int x = this.mapSpace.cLonToX(gpxPoint.getLon().doubleValue(), this.zoom);
        int y = this.mapSpace.cLatToY(gpxPoint.getLat().doubleValue(), this.zoom);
        return new Point(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileImage(int x, int y) throws IOException {
        BufferedImage image = super.getTileImage(x, y);
        int tileSize = this.mapSpace.getTileSize();
        int xMin = tileSize * x;
        int yMin = tileSize * y;
        int xMax = xMin + tileSize - 1;
        int yMax = yMin + tileSize - 1;
        Graphics2D g = (Graphics2D)image.getGraphics();
        try {
            for (Point p : this.points) {
                if (p.x < xMin || p.x > xMax || p.y < yMin || p.y > yMax) continue;
                int px = p.x - xMin;
                int py = p.y - yMin;
                g.drawOval(px, py, 5, 5);
            }
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static class Line {
        public final Point start;
        public final Point end;

        public Line(Point start, Point end) {
            this.start = start;
            this.end = end;
        }
    }
}

