/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.commandline;

import java.io.File;
import javax.xml.bind.JAXBException;
import mobac.program.AtlasThread;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.CommandLineAction;
import mobac.program.model.Profile;
import mobac.utilities.GUIExceptionHandler;

public class CreateAtlas
implements CommandLineAction {
    private final String profileName;
    private final File outputDir;

    public CreateAtlas(String profileName) {
        this(profileName, null);
    }

    public CreateAtlas(String profileName, String outputDirectory) {
        this.profileName = profileName;
        if (outputDirectory != null) {
            File dir2 = new File(outputDirectory);
            if (dir2.isDirectory() || dir2.exists()) {
                System.err.println("Error: Atlas output directory \"" + outputDirectory + "\" already exists.");
                System.exit(1);
            }
            this.outputDir = dir2;
        } else {
            this.outputDir = null;
        }
    }

    @Override
    public void runBeforeMainGUI() {
        try {
            Profile p = new Profile(this.profileName);
            if (!p.exists()) {
                System.err.println("Profile \"" + this.profileName + "\" could not be loaded:");
                System.err.println("File \"" + p.getFile().getAbsolutePath() + "\" does not exist.");
                System.exit(1);
            }
            AtlasInterface atlas = null;
            try {
                atlas = p.load();
            }
            catch (JAXBException e) {
                System.err.println("Error loading profile \"" + this.profileName + "\".");
                e.printStackTrace();
                System.exit(1);
            }
            AtlasThread atlasThread = new AtlasThread(atlas);
            if (this.outputDir != null) {
                atlasThread.setCustomAtlasDir(this.outputDir);
            }
            atlasThread.setQuitMobacAfterAtlasCreation(true);
            atlasThread.start();
        }
        catch (Exception e) {
            GUIExceptionHandler.processException(e);
        }
    }

    @Override
    public void runMainGUI() {
    }

    @Override
    public boolean showSplashScreen() {
        return false;
    }

    @Override
    public boolean showMainGUI() {
        return false;
    }
}

