/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.download;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import mobac.exceptions.DownloadFailedException;
import mobac.exceptions.StopAllDownloadsException;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.program.JobDispatcher;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.interfaces.MapSource;
import mobac.utilities.tar.TarIndexedArchive;
import org.apache.log4j.Logger;

public class DownloadJob
implements JobDispatcher.Job {
    static Logger log = Logger.getLogger(DownloadJob.class);
    int errorCounter = 0;
    final MapSource mapSource;
    final int xValue;
    final int yValue;
    final int zoomValue;
    final TarIndexedArchive tileArchive;
    final DownloadJobListener listener;

    public DownloadJob(MapSource mapSource, int xValue, int yValue, int zoomValue, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        this.mapSource = mapSource;
        this.xValue = xValue;
        this.yValue = yValue;
        this.zoomValue = zoomValue;
        this.tileArchive = tileArchive;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(JobDispatcher dispatcher) throws Exception {
        try {
            this.listener.jobStarted();
            byte[] tileData = this.mapSource.getTileData(this.zoomValue, this.xValue, this.yValue, MapSource.LoadMethod.DEFAULT);
            String tileFileName = String.format("x%dy%d", this.xValue, this.yValue);
            if (this.tileArchive != null) {
                TarIndexedArchive tarIndexedArchive = this.tileArchive;
                synchronized (tarIndexedArchive) {
                    this.tileArchive.writeFileFromData(tileFileName, tileData);
                }
            }
            this.listener.jobFinishedSuccessfully(tileData.length);
        }
        catch (UnrecoverableDownloadException e) {
            this.listener.jobFinishedWithError(false);
            log.error("Download of tile z" + this.zoomValue + "_x" + this.xValue + "_y" + this.yValue + " failed with an unrecoverable error: " + e.getCause());
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (StopAllDownloadsException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            this.processError(dispatcher, e);
        }
        catch (ConnectException e) {
            this.processError(dispatcher, e);
        }
        catch (DownloadFailedException e) {
            this.processError(dispatcher, e);
        }
        catch (Exception e) {
            this.processError(dispatcher, e);
            throw e;
        }
    }

    private void processError(JobDispatcher dispatcher, Exception e) {
        ++this.errorCounter;
        if (this.errorCounter <= this.listener.getMaxDownloadRetries()) {
            this.listener.jobFinishedWithError(true);
            log.warn("Download of tile z" + this.zoomValue + "_x" + this.xValue + "_y" + this.yValue + " failed: \"" + e.getMessage() + "\" (tries: " + this.errorCounter + ") - rescheduling download job");
            dispatcher.addErrorJob(this);
        } else {
            this.listener.jobFinishedWithError(false);
            log.error("Download of tile z" + this.zoomValue + "_x" + this.xValue + "_y" + this.yValue + " failed again: \"" + e.getMessage() + "\". Retry limit reached, job will not be rescheduled (no further try)");
        }
    }

    public String toString() {
        return "DownloadJob x=" + this.xValue + " y=" + this.yValue + " z=" + this.zoomValue;
    }
}

