/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.jaxb;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import mobac.program.model.PaperSize;

public class PaperSizeAdapter
extends XmlAdapter<String, PaperSize> {
    private static final String LANDSCAPE = "_LANDSCAPE";
    private static final String SELECTION = "SELECTION";
    private static final String X = "x";

    public PaperSize unmarshal(String value) throws Exception {
        if (value.equals(SELECTION)) {
            return null;
        }
        if (value.contains(X)) {
            String[] split = value.split(X);
            double width = Double.parseDouble(split[0]);
            double height = Double.parseDouble(split[1]);
            return new PaperSize(width, height);
        }
        boolean landscape = false;
        if (value.contains(LANDSCAPE)) {
            value = value.substring(0, value.indexOf(LANDSCAPE));
            landscape = true;
        }
        PaperSize.Format format = PaperSize.Format.valueOf(value);
        return new PaperSize(format, landscape);
    }

    public String marshal(PaperSize v) throws Exception {
        if (v == null) {
            return SELECTION;
        }
        if (v.format != null) {
            return v.format.name() + (v.landscape ? LANDSCAPE : "");
        }
        return v.width + X + v.height;
    }
}

