/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.ToolTipProvider;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Layer;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.commons.lang3.StringEscapeUtils;

@XmlRootElement
public class Atlas
implements AtlasInterface,
ToolTipProvider,
TreeNode {
    public static final int CURRENT_ATLAS_VERSION = 1;
    @XmlAttribute
    private int version = 0;
    private String name = I18nUtils.localizedStringForKey("Unnamed", new Object[0]);
    @XmlElements(value={@XmlElement(name="Layer", type=Layer.class)})
    private List<LayerInterface> layers = new LinkedList<LayerInterface>();
    private AtlasOutputFormat outputFormat = AtlasOutputFormat.FORMATS.get(0);

    public static Atlas newInstance() {
        Atlas atlas = new Atlas();
        atlas.version = 1;
        return atlas;
    }

    private Atlas() {
    }

    @Override
    public void addLayer(LayerInterface l) {
        this.layers.add(l);
    }

    @Override
    public void deleteLayer(LayerInterface l) {
        this.layers.remove(l);
    }

    @Override
    public LayerInterface getLayer(int index) {
        return this.layers.get(index);
    }

    @Override
    public int getLayerCount() {
        return this.layers.size();
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    @XmlAttribute
    public AtlasOutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public void setOutputFormat(AtlasOutputFormat atlasOutputFormat) {
        if (atlasOutputFormat == null) {
            throw new NullPointerException();
        }
        this.outputFormat = atlasOutputFormat;
    }

    public String toString() {
        return this.getName() + " (" + this.outputFormat + ")";
    }

    @Override
    public Iterator<LayerInterface> iterator() {
        return this.layers.iterator();
    }

    @Override
    public long calculateTilesToDownload() {
        long tiles = 0L;
        for (LayerInterface layer : this.layers) {
            tiles += layer.calculateTilesToDownload();
        }
        return tiles;
    }

    @Override
    public boolean checkData() {
        if (this.name == null) {
            return true;
        }
        HashSet<String> names = new HashSet<String>(this.layers.size());
        for (LayerInterface layer : this.layers) {
            names.add(layer.getName());
        }
        return names.size() < this.layers.size();
    }

    @Override
    public double getMinLat() {
        double lat = 90.0;
        for (LayerInterface l : this.layers) {
            lat = Math.min(lat, l.getMinLat());
        }
        return lat;
    }

    @Override
    public double getMaxLat() {
        double lat = -90.0;
        for (LayerInterface l : this.layers) {
            lat = Math.max(lat, l.getMaxLat());
        }
        return lat;
    }

    @Override
    public double getMinLon() {
        double lon = 180.0;
        for (LayerInterface l : this.layers) {
            lon = Math.min(lon, l.getMinLon());
        }
        return lon;
    }

    @Override
    public double getMaxLon() {
        double lon = -180.0;
        for (LayerInterface l : this.layers) {
            lon = Math.max(lon, l.getMaxLon());
        }
        return lon;
    }

    @Override
    public String getToolTip() {
        StringWriter sw = new StringWriter(1024);
        sw.write("<html>");
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_atlas_title", new Object[0]));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_atlas_name", StringEscapeUtils.escapeHtml4(this.name)));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_atlas_layer", this.layers.size()));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_atlas_format", this.outputFormat.toString()));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_max_tile", this.calculateTilesToDownload()));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_area_start", Utilities.prettyPrintLatLon(this.getMaxLat(), true), Utilities.prettyPrintLatLon(this.getMinLon(), false)));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_area_end", Utilities.prettyPrintLatLon(this.getMinLat(), true), Utilities.prettyPrintLatLon(this.getMaxLon(), false)));
        sw.write("</html>");
        return sw.toString();
    }

    public Enumeration<?> children() {
        return Collections.enumeration(this.layers);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)((Object)this.layers.get(childIndex));
    }

    @Override
    public int getChildCount() {
        return this.layers.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.layers.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public AtlasInterface deepClone() {
        Atlas atlas = new Atlas();
        atlas.version = this.version;
        atlas.name = this.name;
        atlas.outputFormat = this.outputFormat;
        for (LayerInterface layer : this.layers) {
            atlas.layers.add(layer.deepClone(atlas));
        }
        return atlas;
    }
}

