/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.io.File;
import java.util.LinkedList;
import mobac.program.model.Settings;

public class MapSourceLoaderInfo {
    protected final LoaderType loaderType;
    protected final File sourceFile;
    protected final String revision;

    public MapSourceLoaderInfo(LoaderType loaderType, File sourceFile) {
        this(loaderType, sourceFile, null);
    }

    public MapSourceLoaderInfo(LoaderType loaderType, File sourceFile, String revision) {
        this.loaderType = loaderType;
        this.sourceFile = sourceFile;
        this.revision = revision;
    }

    public LoaderType getLoaderType() {
        return this.loaderType;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getRevision() {
        return this.revision;
    }

    public String[] getRelativePath() {
        File mapSourcesDir = Settings.getInstance().getMapSourcesDirectory();
        File dir2 = this.sourceFile.getParentFile();
        LinkedList<String> pathList = new LinkedList<String>();
        while (!mapSourcesDir.equals(dir2)) {
            pathList.offerFirst(dir2.getName());
            dir2 = dir2.getParentFile();
        }
        if (pathList.size() == 0) {
            return null;
        }
        return pathList.toArray(new String[pathList.size()]);
    }

    public static enum LoaderType {
        MAPPACK("Mappack"),
        XML("Custom XML"),
        BSH("BeanShell");

        public final String displayName;

        private LoaderType(String displayName) {
            this.displayName = displayName;
        }
    }
}

