/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import mobac.program.interfaces.MapSource;

public class MapSourcesListModel
extends AbstractListModel {
    ArrayList<MapSource> mapSources;

    public MapSourcesListModel(Vector<MapSource> source) {
        this.mapSources = new ArrayList<MapSource>(source);
    }

    @Override
    public Object getElementAt(int index) {
        return this.mapSources.get(index);
    }

    @Override
    public int getSize() {
        return this.mapSources.size();
    }

    public Vector<MapSource> getVector() {
        return new Vector<MapSource>(this.mapSources);
    }

    public MapSource removeElement(int index) {
        this.fireIntervalRemoved(this, index, index);
        return this.mapSources.remove(index);
    }

    public void addElement(MapSource element) {
        this.mapSources.add(element);
        this.fireIntervalAdded(this, this.mapSources.size(), this.mapSources.size());
    }

    public boolean moveUp(int index) {
        if (index < 1) {
            return false;
        }
        MapSource ms = this.mapSources.remove(index - 1);
        this.mapSources.add(index, ms);
        this.fireContentsChanged(this, index - 1, index);
        return true;
    }

    public boolean moveDown(int index) {
        if (index + 1 >= this.mapSources.size()) {
            return false;
        }
        MapSource ms = this.mapSources.remove(index + 1);
        this.mapSources.add(index, ms);
        this.fireContentsChanged(this, index, index + 1);
        return true;
    }

    public void sort() {
        Collections.sort(this.mapSources, new Comparator<MapSource>(){

            @Override
            public int compare(MapSource o1, MapSource o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.fireContentsChanged(this.mapSources, 0, this.mapSources.size());
    }
}

