/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.util.ArrayList;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageType;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.program.tiledatawriter.TileImagePng4DataWriter;
import mobac.program.tiledatawriter.TileImagePng8DataWriter;
import mobac.program.tiledatawriter.TileImagePngDataWriter;
import mobac.utilities.I18nUtils;

public enum TileImageFormat {
    PNG(new TileImagePngDataWriter(), "lp_tile_param_image_fmt_png"),
    PNG8Bit(new TileImagePng8DataWriter(), "lp_tile_param_image_fmt_png_8bit"),
    PNG4Bit(new TileImagePng4DataWriter(), "lp_tile_param_image_fmt_png_4bit"),
    JPEG100(new TileImageJpegDataWriter(1.0), "lp_tile_param_image_fmt_jpg_q100"),
    JPEG99(new TileImageJpegDataWriter(0.99), "lp_tile_param_image_fmt_jpg_q99"),
    JPEG95(new TileImageJpegDataWriter(0.95), "lp_tile_param_image_fmt_jpg_q95"),
    JPEG90(new TileImageJpegDataWriter(0.9), "lp_tile_param_image_fmt_jpg_q90"),
    JPEG85(new TileImageJpegDataWriter(0.85), "lp_tile_param_image_fmt_jpg_q85"),
    JPEG80(new TileImageJpegDataWriter(0.8), "lp_tile_param_image_fmt_jpg_q80"),
    JPEG70(new TileImageJpegDataWriter(0.7), "lp_tile_param_image_fmt_jpg_q70"),
    JPEG60(new TileImageJpegDataWriter(0.6), "lp_tile_param_image_fmt_jpg_q60"),
    JPEG50(new TileImageJpegDataWriter(0.5), "lp_tile_param_image_fmt_jpg_q50");

    private final TileImageDataWriter dataWriter;
    private final String translationKey;

    private TileImageFormat(TileImageDataWriter dataWriter, String translationKey) {
        this.dataWriter = dataWriter;
        this.translationKey = translationKey;
    }

    public String toString() {
        return I18nUtils.localizedStringForKey(this.translationKey, new Object[0]);
    }

    public TileImageDataWriter getDataWriter() {
        return this.dataWriter;
    }

    public TileImageType getType() {
        return this.dataWriter.getType();
    }

    public String getFileExt() {
        return this.dataWriter.getType().getFileExt();
    }

    public static TileImageFormat[] getPngFormats() {
        return TileImageFormat.getFormats(TileImageType.PNG);
    }

    public static TileImageFormat[] getJpgFormats() {
        return TileImageFormat.getFormats(TileImageType.JPG);
    }

    protected static TileImageFormat[] getFormats(TileImageType tileImageType) {
        ArrayList<TileImageFormat> list = new ArrayList<TileImageFormat>();
        for (TileImageFormat format : TileImageFormat.values()) {
            if (!tileImageType.equals((Object)format.getType())) continue;
            list.add(format);
        }
        TileImageFormat[] result = new TileImageFormat[]{};
        result = list.toArray(result);
        return result;
    }
}

