/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Dimension;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.program.model.AnyAttributeMap;
import mobac.program.model.TileImageFormat;

@XmlRootElement
public final class TileImageParameters
implements Cloneable {
    @XmlAnyAttribute
    protected AnyAttributeMap attr = new AnyAttributeMap();

    protected TileImageParameters() {
    }

    private TileImageParameters(AnyAttributeMap attrMap) {
        this.attr.putAll(attrMap);
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        this.attr.getInt(Name.height.name());
        this.attr.getInt(Name.width.name());
        TileImageFormat.valueOf(this.attr.getAttr("format"));
    }

    public TileImageParameters(int width, int height, TileImageFormat format) {
        this.attr.setAttr("format", format.name());
        this.attr.setInt("height", height);
        this.attr.setInt("width", width);
    }

    public int getWidth() {
        return this.attr.getInt("width");
    }

    public int getHeight() {
        return this.attr.getInt("height");
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public TileImageFormat getFormat() {
        return TileImageFormat.valueOf(this.attr.getAttr("format"));
    }

    public String toString() {
        return "Tile size: (" + this.getWidth() + "/" + this.getHeight() + ") " + this.getFormat().toString() + ")";
    }

    public Object clone() throws CloneNotSupportedException {
        return new TileImageParameters(this.attr);
    }

    public static enum Name {
        width,
        height,
        format,
        format_png,
        format_jpg;

    }
}

