/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tiledatawriter;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageType;
import mobac.program.tiledatawriter.ImageWriterWarningListener;
import org.apache.log4j.Logger;

public class TileImagePngDataWriter
implements TileImageDataWriter {
    protected Logger log = Logger.getLogger(this.getClass());
    protected ImageWriter pngImageWriter = null;

    @Override
    public void initialize() {
        if (this.log.isTraceEnabled()) {
            String s = "Available PNG image writers:";
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
            while (writers.hasNext()) {
                ImageWriter w = writers.next();
                s = s + "\n\t" + w.getClass().getName();
            }
            this.log.trace(s);
        }
        this.pngImageWriter = ImageIO.getImageWritersByFormatName("png").next();
        this.pngImageWriter.addIIOWriteWarningListener(ImageWriterWarningListener.INSTANCE);
        this.log.debug("Used PNG image writer: " + this.pngImageWriter.getClass().getName());
    }

    @Override
    public void processImage(BufferedImage image, OutputStream out) throws IOException {
        this.pngImageWriter.setOutput(ImageIO.createImageOutputStream(out));
        IIOImage ioImage = new IIOImage(image, null, null);
        this.pngImageWriter.write(ioImage);
    }

    @Override
    public void dispose() {
        this.pngImageWriter.dispose();
        this.pngImageWriter = null;
    }

    @Override
    public TileImageType getType() {
        return TileImageType.PNG;
    }
}

