/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilefilter;

import java.awt.Polygon;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.TileFilter;
import mobac.program.model.MapPolygon;

public class PolygonTileFilter
implements TileFilter {
    private final Polygon polygon;
    private final int tileSize;
    private final int polygonZoom;

    public PolygonTileFilter(MapPolygon map) {
        this(map.getPolygon(), map.getZoom(), map.getMapSource());
    }

    public PolygonTileFilter(Polygon polygon, int polygonZoom, MapSource mapSource) {
        this.polygon = polygon;
        this.polygonZoom = polygonZoom;
        this.tileSize = mapSource.getMapSpace().getTileSize();
    }

    @Override
    public boolean testTile(int x, int y, int zoom, MapSource mapSource) {
        if (this.polygonZoom != zoom) {
            throw new RuntimeException("Wrong zoom level!");
        }
        int tileCoordinateX = x * this.tileSize;
        int tileCoordinateY = y * this.tileSize;
        return this.polygon.intersects(tileCoordinateX, tileCoordinateY, this.tileSize, this.tileSize);
    }
}

