/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import mobac.utilities.file.RegexFileFilter;
import org.apache.log4j.Logger;

public class ExtensionClassLoader
extends URLClassLoader {
    private static final Logger log = Logger.getLogger(ExtensionClassLoader.class);
    private File jarDir;

    private ExtensionClassLoader(URL[] urls, File jarDir) throws MalformedURLException {
        super(urls);
        this.jarDir = jarDir;
    }

    public static ExtensionClassLoader create(File[] dirList, String regexFilePattern) throws FileNotFoundException {
        File[] jarFiles = null;
        File jarDir = null;
        for (File dir2 : dirList) {
            File[] files;
            if (dir2 == null || !dir2.isDirectory() || (files = dir2.listFiles(new RegexFileFilter(regexFilePattern))).length <= 0) continue;
            log.debug("Directory: \"" + dir2.getAbsolutePath() + "\"");
            log.debug("Pattern: \"" + regexFilePattern + "\"");
            jarFiles = files;
            jarDir = dir2;
            break;
        }
        if (jarFiles == null) {
            throw new FileNotFoundException("No directory containing \"" + regexFilePattern + "\" found.");
        }
        final URL[] urls = new URL[jarFiles.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = new URL("jar", "", "file:" + jarFiles[i].getAbsolutePath() + "!/");
                continue;
            }
            catch (MalformedURLException e) {
                log.error("", e);
            }
        }
        final File jarDir_ = jarDir;
        ExtensionClassLoader ecl = AccessController.doPrivileged(new PrivilegedAction<ExtensionClassLoader>(){

            @Override
            public ExtensionClassLoader run() {
                try {
                    return new ExtensionClassLoader(urls, jarDir_);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return ecl;
    }

    @Override
    protected String findLibrary(String libname) {
        String mappedLibname = System.mapLibraryName(libname);
        File f = new File(this.jarDir, mappedLibname);
        if (f.isFile()) {
            return f.getAbsolutePath();
        }
        return null;
    }
}

